/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.util;

public class IntList {
    private int[] entries;
    private int count;

    public IntList() {
        this(10);
    }

    public IntList(int capacity) {
        this.entries = new int[capacity];
    }

    public int size() {
        return this.count;
    }

    public boolean contains(int value) {
        int i2 = 0;
        while (i2 < this.count) {
            if (this.entries[i2] == value) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public int get(int i2) {
        if (this.count <= i2) {
            throw new ArrayIndexOutOfBoundsException(i2);
        }
        return this.entries[i2];
    }

    public void clear() {
        this.count = 0;
    }

    public void add(int n) {
        if (this.count == this.entries.length) {
            this.grow();
        }
        this.entries[this.count++] = n;
    }

    public void set(int index, int n) {
        if (this.count < index) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (this.count == index) {
            this.add(n);
        } else {
            this.entries[index] = n;
        }
    }

    public void fillTo(int toIndex, int val) {
        while (this.count < toIndex) {
            this.add(val);
        }
    }

    private void grow() {
        int[] n = new int[(this.entries.length + 16) * 3 / 2];
        System.arraycopy(this.entries, 0, n, 0, this.count);
        this.entries = n;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append('[');
        int i2 = 0;
        while (i2 < this.count) {
            if (i2 > 0) {
                r.append(", ");
            }
            r.append(this.entries[i2]);
            ++i2;
        }
        r.append(']');
        return r.toString();
    }
}

