/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.transport;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.annotations.NonNull;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.annotations.Nullable;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.JGitText;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.AnyObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.Ref;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.RefUpdate;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.RevCommit;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.RevObject;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.RevWalk;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.transport.ReceivePack;

public class ReceiveCommand {
    private final ObjectId oldId;
    private final String oldSymref;
    private final ObjectId newId;
    private final String newSymref;
    private final String name;
    private Type type;
    private boolean typeIsCorrect;
    private Ref ref;
    private Result status = Result.NOT_ATTEMPTED;
    private String message;
    private boolean customRefLog;
    private String refLogMessage;
    private boolean refLogIncludeResult;
    private Boolean forceRefLog;

    public static List<ReceiveCommand> filter(Iterable<ReceiveCommand> in, Result want) {
        ArrayList<ReceiveCommand> r = in instanceof Collection ? new ArrayList(((Collection)in).size()) : new ArrayList<ReceiveCommand>();
        for (ReceiveCommand cmd : in) {
            if (cmd.getResult() != want) continue;
            r.add(cmd);
        }
        return r;
    }

    public static List<ReceiveCommand> filter(List<ReceiveCommand> commands, Result want) {
        return ReceiveCommand.filter(commands, want);
    }

    public static void abort(Iterable<ReceiveCommand> commands) {
        for (ReceiveCommand c : commands) {
            if (c.getResult() != Result.NOT_ATTEMPTED) continue;
            c.setResult(Result.REJECTED_OTHER_REASON, JGitText.get().transactionAborted);
        }
    }

    public static boolean isTransactionAborted(ReceiveCommand cmd) {
        return cmd.getResult() == Result.REJECTED_OTHER_REASON && cmd.getMessage().equals(JGitText.get().transactionAborted);
    }

    public static ReceiveCommand link(@NonNull ObjectId oldId, @NonNull String newTarget, @NonNull String name) {
        return new ReceiveCommand(oldId, newTarget, name);
    }

    public static ReceiveCommand link(@Nullable String oldTarget, @NonNull String newTarget, @NonNull String name) {
        return new ReceiveCommand(oldTarget, newTarget, name);
    }

    public static ReceiveCommand unlink(@NonNull String oldTarget, @NonNull ObjectId newId, @NonNull String name) {
        return new ReceiveCommand(oldTarget, newId, name);
    }

    public ReceiveCommand(ObjectId oldId, ObjectId newId, String name) {
        if (oldId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (newId == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = oldId;
        this.oldSymref = null;
        this.newId = newId;
        this.newSymref = null;
        this.name = name;
        this.type = Type.UPDATE;
        if (ObjectId.zeroId().equals(oldId)) {
            this.type = Type.CREATE;
        }
        if (ObjectId.zeroId().equals(newId)) {
            this.type = Type.DELETE;
        }
    }

    public ReceiveCommand(ObjectId oldId, ObjectId newId, String name, Type type) {
        if (oldId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (newId == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = oldId;
        this.oldSymref = null;
        this.newId = newId;
        this.newSymref = null;
        this.name = name;
        switch (type) {
            case CREATE: {
                if (ObjectId.zeroId().equals(oldId)) break;
                throw new IllegalArgumentException(JGitText.get().createRequiresZeroOldId);
            }
            case DELETE: {
                if (ObjectId.zeroId().equals(newId)) break;
                throw new IllegalArgumentException(JGitText.get().deleteRequiresZeroNewId);
            }
            case UPDATE: 
            case UPDATE_NONFASTFORWARD: {
                if (!ObjectId.zeroId().equals(newId) && !ObjectId.zeroId().equals(oldId)) break;
                throw new IllegalArgumentException(JGitText.get().updateRequiresOldIdAndNewId);
            }
            default: {
                throw new IllegalStateException(JGitText.get().enumValueNotSupported0);
            }
        }
        this.type = type;
    }

    private ReceiveCommand(ObjectId oldId, String newSymref, String name) {
        if (oldId == null) {
            throw new IllegalArgumentException(JGitText.get().oldIdMustNotBeNull);
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = oldId;
        this.oldSymref = null;
        this.newId = ObjectId.zeroId();
        this.newSymref = newSymref;
        this.name = name;
        this.type = AnyObjectId.isEqual(ObjectId.zeroId(), oldId) ? Type.CREATE : (newSymref != null ? Type.UPDATE : Type.DELETE);
        this.typeIsCorrect = true;
    }

    private ReceiveCommand(String oldSymref, ObjectId newId, String name) {
        if (newId == null) {
            throw new IllegalArgumentException(JGitText.get().newIdMustNotBeNull);
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = ObjectId.zeroId();
        this.oldSymref = oldSymref;
        this.newId = newId;
        this.newSymref = null;
        this.name = name;
        this.type = oldSymref == null ? Type.CREATE : (!AnyObjectId.isEqual(ObjectId.zeroId(), newId) ? Type.UPDATE : Type.DELETE);
        this.typeIsCorrect = true;
    }

    private ReceiveCommand(@Nullable String oldTarget, String newTarget, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().nameMustNotBeNullOrEmpty);
        }
        this.oldId = ObjectId.zeroId();
        this.oldSymref = oldTarget;
        this.newId = ObjectId.zeroId();
        this.newSymref = newTarget;
        this.name = name;
        if (oldTarget == null) {
            if (newTarget == null) {
                throw new IllegalArgumentException(JGitText.get().bothRefTargetsMustNotBeNull);
            }
            this.type = Type.CREATE;
        } else {
            this.type = newTarget != null ? Type.UPDATE : Type.DELETE;
        }
        this.typeIsCorrect = true;
    }

    public ObjectId getOldId() {
        return this.oldId;
    }

    @Nullable
    public String getOldSymref() {
        return this.oldSymref;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    @Nullable
    public String getNewSymref() {
        return this.newSymref;
    }

    public String getRefName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Ref getRef() {
        return this.ref;
    }

    public Result getResult() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setRefLogMessage(String msg, boolean appendStatus) {
        this.customRefLog = true;
        if (msg == null && !appendStatus) {
            this.disableRefLog();
        } else if (msg == null && appendStatus) {
            this.refLogMessage = "";
            this.refLogIncludeResult = true;
        } else {
            this.refLogMessage = msg;
            this.refLogIncludeResult = appendStatus;
        }
    }

    public void disableRefLog() {
        this.customRefLog = true;
        this.refLogMessage = null;
        this.refLogIncludeResult = false;
    }

    public void setForceRefLog(boolean force) {
        this.forceRefLog = force;
    }

    public boolean hasCustomRefLog() {
        return this.customRefLog;
    }

    public boolean isRefLogDisabled() {
        return this.refLogMessage == null;
    }

    @Nullable
    public String getRefLogMessage() {
        return this.refLogMessage;
    }

    public boolean isRefLogIncludingResult() {
        return this.refLogIncludeResult;
    }

    @Nullable
    public Boolean isForceRefLog() {
        return this.forceRefLog;
    }

    public void setResult(Result s) {
        this.setResult(s, null);
    }

    public void setResult(Result s, String m) {
        this.status = s;
        this.message = m;
    }

    public void updateType(RevWalk walk) throws IOException {
        if (this.typeIsCorrect) {
            return;
        }
        if (this.type == Type.UPDATE && !AnyObjectId.isEqual(this.oldId, this.newId)) {
            RevObject o = walk.parseAny(this.oldId);
            RevObject n = walk.parseAny(this.newId);
            if (!(o instanceof RevCommit && n instanceof RevCommit && walk.isMergedInto((RevCommit)o, (RevCommit)n))) {
                this.setType(Type.UPDATE_NONFASTFORWARD);
            }
        }
        this.typeIsCorrect = true;
    }

    public void execute(ReceivePack rp) {
        try {
            String expTarget = this.getOldSymref();
            boolean detach = this.getNewSymref() != null || this.type == Type.DELETE && expTarget != null;
            RefUpdate ru = rp.getRepository().updateRef(this.getRefName(), detach);
            if (!(expTarget == null || ru.getRef().isSymbolic() && ru.getRef().getTarget().getName().equals(expTarget))) {
                this.setResult(Result.LOCK_FAILURE);
                return;
            }
            ru.setRefLogIdent(rp.getRefLogIdent());
            ru.setRefLogMessage(this.refLogMessage, this.refLogIncludeResult);
            switch (this.getType()) {
                case DELETE: {
                    if (!ObjectId.zeroId().equals(this.getOldId())) {
                        ru.setExpectedOldObjectId(this.getOldId());
                    }
                    ru.setForceUpdate(true);
                    this.setResult(ru.delete(rp.getRevWalk()));
                    break;
                }
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    ru.setForceUpdate(rp.isAllowNonFastForwards());
                    ru.setExpectedOldObjectId(this.getOldId());
                    ru.setRefLogMessage("push", true);
                    if (this.getNewSymref() != null) {
                        this.setResult(ru.link(this.getNewSymref()));
                        break;
                    }
                    ru.setNewObjectId(this.getNewId());
                    this.setResult(ru.update(rp.getRevWalk()));
                }
            }
        }
        catch (IOException err) {
            this.reject(err);
        }
    }

    void setRef(Ref r) {
        this.ref = r;
    }

    void setType(Type t) {
        this.type = t;
    }

    void setTypeFastForwardUpdate() {
        this.type = Type.UPDATE;
        this.typeIsCorrect = true;
    }

    public void setResult(RefUpdate.Result r) {
        switch (r) {
            case NOT_ATTEMPTED: {
                this.setResult(Result.NOT_ATTEMPTED);
                break;
            }
            case LOCK_FAILURE: 
            case IO_FAILURE: {
                this.setResult(Result.LOCK_FAILURE);
                break;
            }
            case NO_CHANGE: 
            case NEW: 
            case FORCED: 
            case FAST_FORWARD: {
                this.setResult(Result.OK);
                break;
            }
            case REJECTED: {
                this.setResult(Result.REJECTED_NONFASTFORWARD);
                break;
            }
            case REJECTED_CURRENT_BRANCH: {
                this.setResult(Result.REJECTED_CURRENT_BRANCH);
                break;
            }
            case REJECTED_MISSING_OBJECT: {
                this.setResult(Result.REJECTED_MISSING_OBJECT);
                break;
            }
            case REJECTED_OTHER_REASON: {
                this.setResult(Result.REJECTED_OTHER_REASON);
                break;
            }
            default: {
                this.setResult(Result.REJECTED_OTHER_REASON, r.name());
            }
        }
    }

    void reject(IOException err) {
        this.setResult(Result.REJECTED_OTHER_REASON, MessageFormat.format(JGitText.get().lockError, err.getMessage()));
    }

    public String toString() {
        return String.valueOf(this.getType().name()) + ": " + this.getOldId().name() + " " + this.getNewId().name() + " " + this.getRefName();
    }

    public static enum Result {
        NOT_ATTEMPTED,
        REJECTED_NOCREATE,
        REJECTED_NODELETE,
        REJECTED_NONFASTFORWARD,
        REJECTED_CURRENT_BRANCH,
        REJECTED_MISSING_OBJECT,
        REJECTED_OTHER_REASON,
        LOCK_FAILURE,
        OK;

    }

    public static enum Type {
        CREATE,
        UPDATE,
        UPDATE_NONFASTFORWARD,
        DELETE;

    }
}

