/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.transport;

import java.text.MessageFormat;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.annotations.Nullable;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.errors.PackProtocolException;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.JGitText;

public final class FilterSpec {
    private final long blobLimit;
    private final long treeDepthLimit;
    public static final FilterSpec NO_FILTER = new FilterSpec(-1L, -1L);

    private FilterSpec(long blobLimit, long treeDepthLimit) {
        this.blobLimit = blobLimit;
        this.treeDepthLimit = treeDepthLimit;
    }

    public static FilterSpec fromFilterLine(String filterLine) throws PackProtocolException {
        if (filterLine.equals("blob:none")) {
            return FilterSpec.withBlobLimit(0L);
        }
        if (filterLine.startsWith("blob:limit=")) {
            long blobLimit = -1L;
            try {
                blobLimit = Long.parseLong(filterLine.substring("blob:limit=".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (blobLimit >= 0L) {
                return FilterSpec.withBlobLimit(blobLimit);
            }
        } else if (filterLine.startsWith("tree:")) {
            long treeDepthLimit = -1L;
            try {
                treeDepthLimit = Long.parseLong(filterLine.substring("tree:".length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (treeDepthLimit >= 0L) {
                return FilterSpec.withTreeDepthLimit(treeDepthLimit);
            }
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidFilter, filterLine));
    }

    static FilterSpec withBlobLimit(long blobLimit) {
        if (blobLimit < 0L) {
            throw new IllegalArgumentException("blobLimit cannot be negative: " + blobLimit);
        }
        return new FilterSpec(blobLimit, -1L);
    }

    static FilterSpec withTreeDepthLimit(long treeDepthLimit) {
        if (treeDepthLimit < 0L) {
            throw new IllegalArgumentException("treeDepthLimit cannot be negative: " + treeDepthLimit);
        }
        return new FilterSpec(-1L, treeDepthLimit);
    }

    public long getBlobLimit() {
        return this.blobLimit;
    }

    public long getTreeDepthLimit() {
        return this.treeDepthLimit;
    }

    public boolean isNoOp() {
        return this.blobLimit == -1L && this.treeDepthLimit == -1L;
    }

    @Nullable
    public String filterLine() {
        if (this.blobLimit == 0L) {
            return "filter blob:none";
        }
        if (this.blobLimit > 0L) {
            return "filter blob:limit=" + this.blobLimit;
        }
        return null;
    }
}

