/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.AnyObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectIdSet;

public class ObjectIdSubclassMap<V extends ObjectId>
implements Iterable<V>,
ObjectIdSet {
    private static final int INITIAL_TABLE_SIZE = 2048;
    int size;
    private int grow;
    private int mask;
    V[] table;

    public ObjectIdSubclassMap() {
        this.initTable(2048);
    }

    public void clear() {
        this.size = 0;
        this.initTable(2048);
    }

    public V get(AnyObjectId toFind) {
        V obj;
        int msk = this.mask;
        int i2 = toFind.w1 & msk;
        V[] tbl = this.table;
        while ((obj = tbl[i2]) != null) {
            if (AnyObjectId.isEqual(obj, toFind)) {
                return obj;
            }
            i2 = i2 + 1 & msk;
        }
        return null;
    }

    @Override
    public boolean contains(AnyObjectId toFind) {
        return this.get(toFind) != null;
    }

    public <Q extends V> void add(Q newValue) {
        if (++this.size == this.grow) {
            this.grow();
        }
        this.insert(newValue);
    }

    public <Q extends V> V addIfAbsent(Q newValue) {
        V obj;
        int msk = this.mask;
        int i2 = ((ObjectId)newValue).w1 & msk;
        V[] tbl = this.table;
        while ((obj = tbl[i2]) != null) {
            if (AnyObjectId.isEqual(obj, newValue)) {
                return obj;
            }
            i2 = i2 + 1 & msk;
        }
        if (++this.size == this.grow) {
            this.grow();
            this.insert(newValue);
        } else {
            tbl[i2] = newValue;
        }
        return newValue;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<V> iterator() {
        return new Iterator<V>(){
            private int found;
            private int i;

            @Override
            public boolean hasNext() {
                return this.found < ObjectIdSubclassMap.this.size;
            }

            @Override
            public V next() {
                while (this.i < ObjectIdSubclassMap.this.table.length) {
                    Object v;
                    if ((v = ObjectIdSubclassMap.this.table[this.i++]) == null) continue;
                    ++this.found;
                    return v;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void insert(V newValue) {
        int msk = this.mask;
        int j = ((ObjectId)newValue).w1 & msk;
        V[] tbl = this.table;
        while (tbl[j] != null) {
            j = j + 1 & msk;
        }
        tbl[j] = newValue;
    }

    private void grow() {
        V[] oldTable = this.table;
        int oldSize = this.table.length;
        this.initTable(oldSize << 1);
        int i2 = 0;
        while (i2 < oldSize) {
            V obj = oldTable[i2];
            if (obj != null) {
                this.insert(obj);
            }
            ++i2;
        }
    }

    private void initTable(int sz) {
        this.grow = sz >> 1;
        this.mask = sz - 1;
        this.table = this.createArray(sz);
    }

    private final V[] createArray(int sz) {
        return new ObjectId[sz];
    }
}

