/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib;

import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.Config;

public class CoreConfig {
    public static final Config.SectionParser<CoreConfig> KEY = CoreConfig::new;
    private final int compression;
    private final int packIndexVersion;
    private final LogRefUpdates logAllRefUpdates;
    private final String excludesfile;
    private final String attributesfile;

    private CoreConfig(Config rc) {
        this.compression = rc.getInt("core", "compression", -1);
        this.packIndexVersion = rc.getInt("pack", "indexversion", 2);
        this.logAllRefUpdates = rc.getEnum("core", null, "logallrefupdates", LogRefUpdates.TRUE);
        this.excludesfile = rc.getString("core", null, "excludesfile");
        this.attributesfile = rc.getString("core", null, "attributesfile");
    }

    public int getCompression() {
        return this.compression;
    }

    public int getPackIndexVersion() {
        return this.packIndexVersion;
    }

    @Deprecated
    public boolean isLogAllRefUpdates() {
        return !LogRefUpdates.FALSE.equals((Object)this.logAllRefUpdates);
    }

    public String getExcludesFile() {
        return this.excludesfile;
    }

    public String getAttributesFile() {
        return this.attributesfile;
    }

    public static enum AutoCRLF {
        FALSE,
        TRUE,
        INPUT;

    }

    public static enum CheckStat {
        MINIMAL,
        DEFAULT;

    }

    public static enum EOL {
        CRLF,
        LF,
        NATIVE;

    }

    public static enum EolStreamType {
        TEXT_CRLF,
        TEXT_LF,
        AUTO_CRLF,
        AUTO_LF,
        DIRECT;

    }

    public static enum HideDotFiles {
        FALSE,
        TRUE,
        DOTGITONLY;

    }

    public static enum LogRefUpdates {
        FALSE,
        TRUE,
        ALWAYS;

    }

    public static enum SymLinks {
        FALSE,
        TRUE;

    }
}

