/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable.LogCursor;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable.MergedReftable;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable.RefCursor;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableConfig;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableWriter;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.PersonIdent;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ReflogEntry;

public class ReftableCompactor {
    private final ReftableWriter writer;
    private final ArrayDeque<ReftableReader> tables = new ArrayDeque();
    private long compactBytesLimit;
    private long bytesToCompact;
    private boolean includeDeletes;
    private long minUpdateIndex = -1L;
    private long maxUpdateIndex;
    private long oldestReflogTimeMillis;
    private ReftableWriter.Stats stats;

    public ReftableCompactor(OutputStream out) {
        this.writer = new ReftableWriter(out);
    }

    public ReftableCompactor setConfig(ReftableConfig cfg) {
        this.writer.setConfig(cfg);
        return this;
    }

    public ReftableCompactor setCompactBytesLimit(long bytes) {
        this.compactBytesLimit = bytes;
        return this;
    }

    public ReftableCompactor setIncludeDeletes(boolean deletes) {
        this.includeDeletes = deletes;
        return this;
    }

    public ReftableCompactor setMinUpdateIndex(long min) {
        this.minUpdateIndex = min;
        return this;
    }

    public ReftableCompactor setMaxUpdateIndex(long max) {
        this.maxUpdateIndex = max;
        return this;
    }

    public ReftableCompactor setOldestReflogTimeMillis(long timeMillis) {
        this.oldestReflogTimeMillis = timeMillis;
        return this;
    }

    public void addAll(List<ReftableReader> readers) throws IOException {
        for (ReftableReader r : readers) {
            this.tables.add(r);
            this.adjustUpdateIndexes(r);
        }
    }

    public boolean tryAddFirst(ReftableReader reader) throws IOException {
        long sz = reader.size();
        if (this.compactBytesLimit > 0L && this.bytesToCompact + sz > this.compactBytesLimit) {
            return false;
        }
        this.bytesToCompact += sz;
        this.adjustUpdateIndexes(reader);
        this.tables.addFirst(reader);
        return true;
    }

    private void adjustUpdateIndexes(ReftableReader reader) throws IOException {
        this.minUpdateIndex = this.minUpdateIndex == -1L ? reader.minUpdateIndex() : Math.min(this.minUpdateIndex, reader.minUpdateIndex());
        this.maxUpdateIndex = Math.max(this.maxUpdateIndex, reader.maxUpdateIndex());
    }

    public void compact() throws IOException {
        MergedReftable mr = new MergedReftable(new ArrayList<ReftableReader>(this.tables));
        mr.setIncludeDeletes(this.includeDeletes);
        this.writer.setMinUpdateIndex(Math.max(this.minUpdateIndex, 0L));
        this.writer.setMaxUpdateIndex(this.maxUpdateIndex);
        this.writer.begin();
        this.mergeRefs(mr);
        this.mergeLogs(mr);
        this.writer.finish();
        this.stats = this.writer.getStats();
    }

    public ReftableWriter.Stats getStats() {
        return this.stats;
    }

    private void mergeRefs(MergedReftable mr) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RefCursor rc = mr.allRefs();){
            while (rc.next()) {
                this.writer.writeRef(rc.getRef(), rc.getRef().getUpdateIndex());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void mergeLogs(MergedReftable mr) throws IOException {
        if (this.oldestReflogTimeMillis == Long.MAX_VALUE) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (LogCursor lc = mr.allLogs();){
            while (lc.next()) {
                long updateIndex = lc.getUpdateIndex();
                if (updateIndex < this.minUpdateIndex || updateIndex > this.maxUpdateIndex) continue;
                String refName = lc.getRefName();
                ReflogEntry log = lc.getReflogEntry();
                if (log == null) {
                    if (!this.includeDeletes) continue;
                    this.writer.deleteLog(refName, updateIndex);
                    continue;
                }
                PersonIdent who = log.getWho();
                if (who.getWhen().getTime() < this.oldestReflogTimeMillis) continue;
                this.writer.writeLog(refName, updateIndex, who, log.getOldId(), log.getNewId(), log.getComment());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

