/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.annotations.Nullable;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.errors.MissingObjectException;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.errors.StoredObjectRepresentationNotAvailableException;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.JGitText;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.ByteArrayWindow;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.ByteWindow;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.DeltaBaseCache;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.FileObjectDatabase;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.LocalCachedPack;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.LocalObjectToPack;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.ObjectDirectoryInserter;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.PackFile;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.WindowCache;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.pack.CachedPack;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.pack.ObjectReuseAsIs;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.pack.PackOutputStream;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.AnyObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.BitmapIndex;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.InflaterCache;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectInserter;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectLoader;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectReader;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ProgressMonitor;

final class WindowCursor
extends ObjectReader
implements ObjectReuseAsIs {
    final byte[] tempId = new byte[20];
    private Inflater inf;
    private ByteWindow window;
    private DeltaBaseCache baseCache;
    @Nullable
    private final ObjectInserter createdFromInserter;
    final FileObjectDatabase db;

    WindowCursor(FileObjectDatabase db) {
        this.db = db;
        this.createdFromInserter = null;
        this.streamFileThreshold = WindowCache.getStreamFileThreshold();
    }

    WindowCursor(FileObjectDatabase db, @Nullable ObjectDirectoryInserter createdFromInserter) {
        this.db = db;
        this.createdFromInserter = createdFromInserter;
        this.streamFileThreshold = WindowCache.getStreamFileThreshold();
    }

    DeltaBaseCache getDeltaBaseCache() {
        if (this.baseCache == null) {
            this.baseCache = new DeltaBaseCache();
        }
        return this.baseCache;
    }

    @Override
    public ObjectReader newReader() {
        return new WindowCursor(this.db);
    }

    @Override
    public BitmapIndex getBitmapIndex() throws IOException {
        for (PackFile pack : this.db.getPacks()) {
            PackBitmapIndex index = pack.getBitmapIndex();
            if (index == null) continue;
            return new BitmapIndexImpl(index);
        }
        return null;
    }

    @Override
    public Collection<CachedPack> getCachedPacksAndUpdate(BitmapIndex.BitmapBuilder needBitmap) throws IOException {
        for (PackFile pack : this.db.getPacks()) {
            PackBitmapIndex index = pack.getBitmapIndex();
            if (!needBitmap.removeAllOrNone(index)) continue;
            return Collections.singletonList(new LocalCachedPack(Collections.singletonList(pack)));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<ObjectId> resolve(AbbreviatedObjectId id) throws IOException {
        if (id.isComplete()) {
            return Collections.singleton(id.toObjectId());
        }
        HashSet<ObjectId> matches = new HashSet<ObjectId>(4);
        this.db.resolve(matches, id);
        return matches;
    }

    @Override
    public boolean has(AnyObjectId objectId) throws IOException {
        return this.db.has(objectId);
    }

    @Override
    public ObjectLoader open(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ObjectLoader ldr = this.db.openObject(this, objectId);
        if (ldr == null) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        if (typeHint != -1 && ldr.getType() != typeHint) {
            throw new IncorrectObjectTypeException(objectId.copy(), typeHint);
        }
        return ldr;
    }

    @Override
    public Set<ObjectId> getShallowCommits() throws IOException {
        return this.db.getShallowCommits();
    }

    @Override
    public long getObjectSize(AnyObjectId objectId, int typeHint) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        long sz = this.db.getObjectSize(this, objectId);
        if (sz < 0L) {
            if (typeHint == -1) {
                throw new MissingObjectException(objectId.copy(), JGitText.get().unknownObjectType2);
            }
            throw new MissingObjectException(objectId.copy(), typeHint);
        }
        return sz;
    }

    @Override
    public LocalObjectToPack newObjectToPack(AnyObjectId objectId, int type) {
        return new LocalObjectToPack(objectId, type);
    }

    @Override
    public void selectObjectRepresentation(PackWriter packer, ProgressMonitor monitor, Iterable<ObjectToPack> objects) throws IOException, MissingObjectException {
        for (ObjectToPack otp : objects) {
            this.db.selectObjectRepresentation(packer, otp, this);
            monitor.update(1);
        }
    }

    @Override
    public void copyObjectAsIs(PackOutputStream out, ObjectToPack otp, boolean validate) throws IOException, StoredObjectRepresentationNotAvailableException {
        LocalObjectToPack src = (LocalObjectToPack)otp;
        src.pack.copyAsIs(out, src, validate, this);
    }

    @Override
    public void writeObjects(PackOutputStream out, List<ObjectToPack> list) throws IOException {
        for (ObjectToPack otp : list) {
            out.writeObject(otp);
        }
    }

    int copy(PackFile pack, long position, byte[] dstbuf, int dstoff, int cnt) throws IOException {
        long length = pack.length;
        int need = cnt;
        while (need > 0 && position < length) {
            this.pin(pack, position);
            int r = this.window.copy(position, dstbuf, dstoff, need);
            position += (long)r;
            dstoff += r;
            need -= r;
        }
        return cnt - need;
    }

    @Override
    public void copyPackAsIs(PackOutputStream out, CachedPack pack) throws IOException {
        ((LocalCachedPack)pack).copyAsIs(out, this);
    }

    void copyPackAsIs(PackFile pack, long length, PackOutputStream out) throws IOException {
        long position = 12L;
        long remaining = length - 32L;
        while (0L < remaining) {
            this.pin(pack, position);
            int ptr = (int)(position - this.window.start);
            int n = (int)Math.min((long)(this.window.size() - ptr), remaining);
            this.window.write(out, position, n);
            position += (long)n;
            remaining -= (long)n;
        }
    }

    int inflate(PackFile pack, long position, byte[] dstbuf, boolean headerOnly) throws IOException, DataFormatException {
        this.prepareInflater();
        this.pin(pack, position);
        position += (long)this.window.setInput(position, this.inf);
        int dstoff = 0;
        while (true) {
            int n = this.inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff);
            if (this.inf.finished() || headerOnly && (dstoff += n) == dstbuf.length) {
                return dstoff;
            }
            if (this.inf.needsInput()) {
                this.pin(pack, position);
                position += (long)this.window.setInput(position, this.inf);
                continue;
            }
            if (n == 0) break;
        }
        throw new DataFormatException();
    }

    ByteArrayWindow quickCopy(PackFile p, long pos, long cnt) throws IOException {
        this.pin(p, pos);
        if (this.window instanceof ByteArrayWindow && this.window.contains(p, pos + (cnt - 1L))) {
            return (ByteArrayWindow)this.window;
        }
        return null;
    }

    Inflater inflater() {
        this.prepareInflater();
        return this.inf;
    }

    private void prepareInflater() {
        if (this.inf == null) {
            this.inf = InflaterCache.get();
        } else {
            this.inf.reset();
        }
    }

    void pin(PackFile pack, long position) throws IOException {
        ByteWindow w = this.window;
        if (w == null || !w.contains(pack, position)) {
            this.window = null;
            this.window = WindowCache.get(pack, position);
        }
    }

    @Override
    @Nullable
    public ObjectInserter getCreatedFromInserter() {
        return this.createdFromInserter;
    }

    @Override
    public void close() {
        this.window = null;
        this.baseCache = null;
        try {
            InflaterCache.release(this.inf);
        }
        finally {
            this.inf = null;
        }
    }
}

