/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.EWAHCompressedBitmap;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.JGitText;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.BasePackBitmapIndex;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.file.BitmapIndexImpl;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.storage.pack.ObjectToPack;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.AnyObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.BitmapIndex;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectId;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.util.BlockList;

public class PackBitmapIndexBuilder
extends BasePackBitmapIndex {
    private static final int MAX_XOR_OFFSET_SEARCH = 10;
    private final EWAHCompressedBitmap commits;
    private final EWAHCompressedBitmap trees;
    private final EWAHCompressedBitmap blobs;
    private final EWAHCompressedBitmap tags;
    private final BlockList<PositionEntry> byOffset;
    final BlockList<BasePackBitmapIndex.StoredBitmap> byAddOrder = new BlockList();
    final ObjectIdOwnerMap<PositionEntry> positionEntries = new ObjectIdOwnerMap();

    public PackBitmapIndexBuilder(List<ObjectToPack> objects) {
        super(new ObjectIdOwnerMap<BasePackBitmapIndex.StoredBitmap>());
        this.byOffset = new BlockList(objects.size());
        PackBitmapIndexBuilder.sortByOffsetAndIndex(this.byOffset, this.positionEntries, objects);
        int sizeInWords = Math.max(4, this.byOffset.size() / 64 / 3);
        this.commits = new EWAHCompressedBitmap(sizeInWords);
        this.trees = new EWAHCompressedBitmap(sizeInWords);
        this.blobs = new EWAHCompressedBitmap(sizeInWords);
        this.tags = new EWAHCompressedBitmap(sizeInWords);
        int i2 = 0;
        while (i2 < objects.size()) {
            int type = objects.get(i2).getType();
            switch (type) {
                case 1: {
                    this.commits.set(i2);
                    break;
                }
                case 2: {
                    this.trees.set(i2);
                    break;
                }
                case 3: {
                    this.blobs.set(i2);
                    break;
                }
                case 4: {
                    this.tags.set(i2);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().badObjectType, String.valueOf(type)));
                }
            }
            ++i2;
        }
        this.commits.trim();
        this.trees.trim();
        this.blobs.trim();
        this.tags.trim();
    }

    private static void sortByOffsetAndIndex(BlockList<PositionEntry> byOffset, ObjectIdOwnerMap<PositionEntry> positionEntries, List<ObjectToPack> entries) {
        int i2 = 0;
        while (i2 < entries.size()) {
            positionEntries.add(new PositionEntry(entries.get(i2), i2));
            ++i2;
        }
        Collections.sort(entries, (a, b) -> Long.signum(a.getOffset() - b.getOffset()));
        i2 = 0;
        while (i2 < entries.size()) {
            PositionEntry e = positionEntries.get(entries.get(i2));
            e.offsetPosition = i2++;
            byOffset.add(e);
        }
    }

    public ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> getObjectSet() {
        ObjectIdOwnerMap<ObjectIdOwnerMap.Entry> r = new ObjectIdOwnerMap<ObjectIdOwnerMap.Entry>();
        for (PositionEntry e : this.byOffset) {
            r.add(new ObjectIdOwnerMap.Entry(e){});
        }
        return r;
    }

    public void addBitmap(AnyObjectId objectId, BitmapIndex.Bitmap bitmap, int flags) {
        if (bitmap instanceof BitmapIndex.BitmapBuilder) {
            bitmap = ((BitmapIndex.BitmapBuilder)bitmap).build();
        }
        if (!(bitmap instanceof BitmapIndexImpl.CompressedBitmap)) {
            throw new IllegalArgumentException(bitmap.getClass().toString());
        }
        EWAHCompressedBitmap compressed = ((BitmapIndexImpl.CompressedBitmap)bitmap).getEwahCompressedBitmap();
        this.addBitmap(objectId, compressed, flags);
    }

    public void addBitmap(AnyObjectId objectId, EWAHCompressedBitmap bitmap, int flags) {
        bitmap.trim();
        BasePackBitmapIndex.StoredBitmap result = new BasePackBitmapIndex.StoredBitmap(objectId, bitmap, null, flags);
        this.getBitmaps().add(result);
        this.byAddOrder.add(result);
    }

    @Override
    public EWAHCompressedBitmap ofObjectType(EWAHCompressedBitmap bitmap, int type) {
        switch (type) {
            case 3: {
                return this.getBlobs().and(bitmap);
            }
            case 2: {
                return this.getTrees().and(bitmap);
            }
            case 1: {
                return this.getCommits().and(bitmap);
            }
            case 4: {
                return this.getTags().and(bitmap);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int findPosition(AnyObjectId objectId) {
        PositionEntry entry = this.positionEntries.get(objectId);
        if (entry == null) {
            return -1;
        }
        return entry.offsetPosition;
    }

    @Override
    public ObjectId getObject(int position) throws IllegalArgumentException {
        ObjectId objectId = this.byOffset.get(position);
        if (objectId == null) {
            throw new IllegalArgumentException();
        }
        return objectId;
    }

    public EWAHCompressedBitmap getCommits() {
        return this.commits;
    }

    public EWAHCompressedBitmap getTrees() {
        return this.trees;
    }

    public EWAHCompressedBitmap getBlobs() {
        return this.blobs;
    }

    public EWAHCompressedBitmap getTags() {
        return this.tags;
    }

    public int getOptions() {
        return 1;
    }

    @Override
    public int getBitmapCount() {
        return this.getBitmaps().size();
    }

    public void clearBitmaps() {
        this.byAddOrder.clear();
        this.getBitmaps().clear();
    }

    @Override
    public int getObjectCount() {
        return this.byOffset.size();
    }

    public Iterable<StoredEntry> getCompressedBitmaps() {
        return () -> new Iterator<StoredEntry>(){
            private int index;
            {
                this.index = PackBitmapIndexBuilder.this.byAddOrder.size() - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public StoredEntry next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                BasePackBitmapIndex.StoredBitmap item = PackBitmapIndexBuilder.this.byAddOrder.get(this.index);
                int bestXorOffset = 0;
                EWAHCompressedBitmap bestBitmap = item.getBitmap();
                int i2 = 1;
                while (i2 <= 10) {
                    int curr = i2 + this.index;
                    if (curr >= PackBitmapIndexBuilder.this.byAddOrder.size()) break;
                    BasePackBitmapIndex.StoredBitmap other = PackBitmapIndexBuilder.this.byAddOrder.get(curr);
                    EWAHCompressedBitmap bitmap = other.getBitmap().xor(item.getBitmap());
                    if (bitmap.sizeInBytes() < bestBitmap.sizeInBytes()) {
                        bestBitmap = bitmap;
                        bestXorOffset = i2;
                    }
                    ++i2;
                }
                --this.index;
                PositionEntry entry = PackBitmapIndexBuilder.this.positionEntries.get(item);
                if (entry == null) {
                    throw new IllegalStateException();
                }
                bestBitmap.trim();
                return new StoredEntry(entry.namePosition, bestBitmap, bestXorOffset, item.getFlags());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static final class PositionEntry
    extends ObjectIdOwnerMap.Entry {
        final int namePosition;
        int offsetPosition;

        PositionEntry(AnyObjectId objectId, int namePosition) {
            super(objectId);
            this.namePosition = namePosition;
        }
    }

    public static final class StoredEntry {
        private final long objectId;
        private final EWAHCompressedBitmap bitmap;
        private final int xorOffset;
        private final int flags;

        StoredEntry(long objectId, EWAHCompressedBitmap bitmap, int xorOffset, int flags) {
            this.objectId = objectId;
            this.bitmap = bitmap;
            this.xorOffset = xorOffset;
            this.flags = flags;
        }

        public EWAHCompressedBitmap getBitmap() {
            return this.bitmap;
        }

        public int getXorOffset() {
            return this.xorOffset;
        }

        public int getFlags() {
            return this.flags;
        }

        public long getObjectId() {
            return this.objectId;
        }
    }
}

