/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.org.eclipse.jgit.internal.revwalk;

import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.BitmapIndex;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.RevCommit;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.RevFlag;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.RevWalk;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.revwalk.filter.RevFilter;

public class AddToBitmapFilter
extends RevFilter {
    private final BitmapIndex.BitmapBuilder bitmap;

    public AddToBitmapFilter(BitmapIndex.BitmapBuilder bitmap) {
        this.bitmap = bitmap;
    }

    @Override
    public final boolean include(RevWalk walker, RevCommit cmit) {
        if (!this.bitmap.contains(cmit)) {
            BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(cmit);
            if (visitedBitmap != null) {
                this.bitmap.or(visitedBitmap);
            } else {
                this.bitmap.addObject(cmit, 1);
                return true;
            }
        }
        RevCommit[] revCommitArray = cmit.getParents();
        int n = revCommitArray.length;
        int n2 = 0;
        while (n2 < n) {
            RevCommit p = revCommitArray[n2];
            p.add(RevFlag.SEEN);
            ++n2;
        }
        return false;
    }

    @Override
    public final RevFilter clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean requiresCommitBody() {
        return false;
    }
}

