/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.com.googlecode.javaewah;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.CloneableIterator;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.EWAHCompressedBitmap;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.EWAHIterator;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.IteratingRLW;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.IteratorAggregation;

class BufferedXORIterator
implements CloneableIterator<EWAHIterator> {
    EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    long[] hardbitmap;
    LinkedList<IteratingRLW> ll;

    BufferedXORIterator(LinkedList<IteratingRLW> basell, int bufSize) {
        this.ll = basell;
        this.hardbitmap = new long[bufSize];
    }

    public BufferedXORIterator clone() throws CloneNotSupportedException {
        BufferedXORIterator answer = (BufferedXORIterator)super.clone();
        answer.buffer = this.buffer.clone();
        answer.hardbitmap = (long[])this.hardbitmap.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        long effective = 0L;
        Iterator i2 = this.ll.iterator();
        while (i2.hasNext()) {
            IteratingRLW rlw = (IteratingRLW)i2.next();
            if (rlw.size() > 0L) {
                int eff = IteratorAggregation.inplacexor(this.hardbitmap, rlw);
                if ((long)eff <= effective) continue;
                effective = eff;
                continue;
            }
            i2.remove();
        }
        int k = 0;
        while ((long)k < effective) {
            this.buffer.addWord(this.hardbitmap[k]);
            ++k;
        }
        Arrays.fill(this.hardbitmap, 0L);
        return this.buffer.getEWAHIterator();
    }
}

