/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.shadow.com.googlecode.javaewah;

import java.util.Iterator;
import java.util.LinkedList;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.CloneableIterator;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.EWAHCompressedBitmap;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.EWAHIterator;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.IteratingRLW;
import org.jlleitschuh.gradle.shadow.com.googlecode.javaewah.IteratorAggregation;

class BufferedAndIterator
implements CloneableIterator<EWAHIterator> {
    EWAHCompressedBitmap buffer = new EWAHCompressedBitmap();
    LinkedList<IteratingRLW> ll;
    final int bufferSize;

    public BufferedAndIterator(LinkedList<IteratingRLW> basell, int bufSize) {
        this.ll = basell;
        this.bufferSize = bufSize;
    }

    @Override
    public boolean hasNext() {
        return !this.ll.isEmpty();
    }

    public BufferedAndIterator clone() throws CloneNotSupportedException {
        BufferedAndIterator answer = (BufferedAndIterator)super.clone();
        answer.buffer = this.buffer.clone();
        answer.ll = (LinkedList)this.ll.clone();
        return answer;
    }

    @Override
    public EWAHIterator next() {
        this.buffer.clear();
        IteratorAggregation.andToContainer(this.buffer, this.bufferSize * this.ll.size(), this.ll.get(0), this.ll.get(1));
        if (this.ll.size() > 2) {
            Iterator i2 = this.ll.iterator();
            i2.next();
            i2.next();
            EWAHCompressedBitmap tmpbuffer = new EWAHCompressedBitmap();
            while (i2.hasNext() && this.buffer.sizeInBytes() > 0) {
                IteratorAggregation.andToContainer(tmpbuffer, this.buffer.getIteratingRLW(), (IteratingRLW)i2.next());
                this.buffer.swap(tmpbuffer);
                tmpbuffer.clear();
            }
        }
        for (IteratingRLW aLl : this.ll) {
            if (aLl.size() != 0L) continue;
            this.ll.clear();
            break;
        }
        return this.buffer.getEWAHIterator();
    }
}

