/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint.worker;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.KtLintCompatibilityKt;
import org.jlleitschuh.gradle.ktlint.worker.KtLintClassesSerializer;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation100;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation47;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation48;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation49;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation50;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocationFactory;
import org.jlleitschuh.gradle.ktlint.worker.KtLintWorkAction;
import org.jlleitschuh.gradle.ktlint.worker.LintErrorResult;
import org.jlleitschuh.gradle.shadow.net.swiftzer.semver.SemVer;
import org.jlleitschuh.gradle.shadow.org.apache.commons.io.input.MessageDigestCalculatingInputStream;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lorg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction$KtLintWorkParameters;", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "execute", "", "generateUserData", "", "", "resetEditorconfigCache", "ktLintInvocation", "Lorg/jlleitschuh/gradle/ktlint/worker/KtLintInvocation;", "FormatTaskSnapshot", "KtLintWorkParameters", "ktlint-gradle"})
@SourceDebugExtension(value={"SMAP\nKtLintWorkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtLintWorkAction.kt\norg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,184:1\n1855#2,2:185\n1#3:187\n*E\n*S KotlinDebug\n*F\n+ 1 KtLintWorkAction.kt\norg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction\n*L\n78#1,2:185\n*E\n"})
public abstract class KtLintWorkAction
implements WorkAction<KtLintWorkParameters> {
    private final Logger logger = Logging.getLogger((String)"ktlint-worker");

    public void execute() {
        KtLintInvocation ktLintInvocation;
        Map<String, String> userData = this.generateUserData();
        Object object = ((KtLintWorkParameters)this.getParameters()).getDebug().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.debug.get()");
        boolean debug = (Boolean)object;
        Object object2 = ((KtLintWorkParameters)this.getParameters()).getFormatSource().getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.formatSource.getOrElse(false)");
        boolean formatSource = (Boolean)object2;
        List results = new ArrayList();
        Map formattedFiles = new LinkedHashMap();
        if (((KtLintWorkParameters)this.getParameters()).getAdditionalEditorconfig().isPresent()) {
            Object object3 = ((KtLintWorkParameters)this.getParameters()).getAdditionalEditorconfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.additionalEditorconfig.get()");
            Map map = (Map)object3;
            if (!map.isEmpty() && ((SemVer)((KtLintWorkParameters)this.getParameters()).getKtLintVersion().map((Transformer)execute.1.INSTANCE).get()).compareTo(new SemVer(0, 49, 0, null, null, 28, null)) < 0) {
                this.logger.warn("additionalEditorconfig not supported until ktlint 0.49");
            }
        }
        Object object4 = ((KtLintWorkParameters)this.getParameters()).getKtLintVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.ktLintVersion.get()");
        KtLintInvocationFactory ktlintInvokerFactory = KtLintCompatibilityKt.selectInvocation((String)object4);
        if (ktlintInvokerFactory instanceof KtLintInvocation47.Factory) {
            KtLintInvocation47.Factory factory = (KtLintInvocation47.Factory)ktlintInvokerFactory;
            Object object5 = ((KtLintWorkParameters)this.getParameters()).getEnableExperimental().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.enableExperimental.getOrElse(false)");
            boolean bl = (Boolean)object5;
            Object object6 = ((KtLintWorkParameters)this.getParameters()).getDisabledRules().getOrElse((Object)SetsKt.emptySet());
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.disabledRules.getOrElse(emptySet())");
            ktLintInvocation = factory.initialize(null, userData, debug, bl, (Set)object6);
        } else if (ktlintInvokerFactory instanceof KtLintInvocation48.Factory) {
            KtLintInvocation48.Factory factory = (KtLintInvocation48.Factory)ktlintInvokerFactory;
            Object object7 = ((KtLintWorkParameters)this.getParameters()).getEnableExperimental().getOrElse((Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"parameters.enableExperimental.getOrElse(false)");
            boolean bl = (Boolean)object7;
            Object object8 = ((KtLintWorkParameters)this.getParameters()).getDisabledRules().getOrElse((Object)SetsKt.emptySet());
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"parameters.disabledRules.getOrElse(emptySet())");
            ktLintInvocation = factory.initialize(userData, bl, (Set)object8);
        } else if (ktlintInvokerFactory instanceof KtLintInvocation49.Factory) {
            KtLintInvocation49.Factory factory = (KtLintInvocation49.Factory)ktlintInvokerFactory;
            Object object9 = ((KtLintWorkParameters)this.getParameters()).getAdditionalEditorconfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"parameters.additionalEditorconfig.get()");
            ktLintInvocation = factory.initialize((Map)object9);
        } else if (ktlintInvokerFactory instanceof KtLintInvocation50.Factory) {
            KtLintInvocation50.Factory factory = (KtLintInvocation50.Factory)ktlintInvokerFactory;
            Object object10 = ((KtLintWorkParameters)this.getParameters()).getAdditionalEditorconfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"parameters.additionalEditorconfig.get()");
            ktLintInvocation = factory.initialize((Map)object10);
        } else if (ktlintInvokerFactory instanceof KtLintInvocation100.Factory) {
            KtLintInvocation100.Factory factory = (KtLintInvocation100.Factory)ktlintInvokerFactory;
            Object object11 = ((KtLintWorkParameters)this.getParameters()).getAdditionalEditorconfig().get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"parameters.additionalEditorconfig.get()");
            ktLintInvocation = factory.initialize((Map)object11);
        } else {
            throw (Throwable)new GradleException("Incompatible ktlint version " + ((KtLintWorkParameters)this.getParameters()).getKtLintVersion());
        }
        KtLintInvocation ktlintInvoker = ktLintInvocation;
        this.resetEditorconfigCache(ktlintInvoker);
        Set set = ((KtLintWorkParameters)this.getParameters()).getFilesToLint().getFiles();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"parameters.filesToLint.files");
        Object $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            File it = (File)element$iv;
            boolean bl = false;
            try {
                if (formatSource) {
                    File file = it;
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                    String currentFileContent = FilesKt.readText$default((File)file, null, (int)1, null);
                    Pair<String, LintErrorResult> result = ktlintInvoker.invokeFormat(it);
                    results.add(result.getSecond());
                    String updatedFileContent = (String)result.getFirst();
                    if (!(Intrinsics.areEqual((Object)updatedFileContent, (Object)currentFileContent) ^ true)) continue;
                    formattedFiles.put(it, FormatTaskSnapshot.Companion.contentHash(it));
                    FilesKt.writeText$default((File)it, (String)updatedFileContent, null, (int)2, null);
                    continue;
                }
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                LintErrorResult result = ktlintInvoker.invokeLint(file);
                results.add(result);
            }
            catch (RuntimeException e) {
                this.logger.error(e.getMessage());
                StringBuilder stringBuilder = new StringBuilder().append("KtLint failed to parse file: ");
                File file = it;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"it");
                throw (Throwable)new GradleException(stringBuilder.append(file.getAbsolutePath()).toString(), (Throwable)e);
            }
        }
        KtLintClassesSerializer ktLintClassesSerializer = KtLintClassesSerializer.Companion.create();
        Object object12 = ((KtLintWorkParameters)this.getParameters()).getDiscoveredErrorsFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object12, (String)"parameters.discoveredErrorsFile.asFile.get()");
        ktLintClassesSerializer.saveErrors(results, (File)object12);
        $this$forEach$iv = formattedFiles;
        if (!$this$forEach$iv.isEmpty()) {
            Object object13 = ((KtLintWorkParameters)this.getParameters()).getFormatSnapshot().get();
            Intrinsics.checkNotNullExpressionValue((Object)object13, (String)"parameters.formatSnapshot.get()");
            File it = $i$f$forEach = ((RegularFile)object13).getAsFile();
            boolean bl = false;
            if (!it.exists()) {
                it.createNewFile();
            }
            File file = $i$f$forEach;
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.formatSnapsho\u2026s()) it.createNewFile() }");
            File snapshotFile = file;
            FormatTaskSnapshot snapshot = new FormatTaskSnapshot(formattedFiles);
            FormatTaskSnapshot.Companion.writeIntoFile(snapshotFile, snapshot);
        }
    }

    private final void resetEditorconfigCache(KtLintInvocation ktLintInvocation) {
        Object object = ((KtLintWorkParameters)this.getParameters()).getEditorconfigFilesWereChanged().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.editorconfigFilesWereChanged.get()");
        if (((Boolean)object).booleanValue()) {
            this.logger.info("Resetting KtLint caches");
            ktLintInvocation.trimMemory();
        }
    }

    private final Map<String, String> generateUserData() {
        Map userData = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"android", (Object)String.valueOf((Boolean)((KtLintWorkParameters)this.getParameters()).getAndroid().get()))});
        Object object = ((KtLintWorkParameters)this.getParameters()).getDisabledRules().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.disabledRules.get()");
        Set disabledRules = (Set)object;
        Collection collection = disabledRules;
        if (!collection.isEmpty()) {
            userData.put("disabled_rules", CollectionsKt.joinToString$default((Iterable)disabledRules, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        return MapsKt.toMap((Map)userData);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u0018\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0012\u0010\u001e\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0015R\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006$\u00c0\u0006\u0001"}, d2={"Lorg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction$KtLintWorkParameters;", "Lorg/gradle/workers/WorkParameters;", "additionalEditorconfig", "Lorg/gradle/api/provider/MapProperty;", "", "getAdditionalEditorconfig", "()Lorg/gradle/api/provider/MapProperty;", "android", "Lorg/gradle/api/provider/Property;", "", "getAndroid", "()Lorg/gradle/api/provider/Property;", "debug", "getDebug", "disabledRules", "Lorg/gradle/api/provider/SetProperty;", "getDisabledRules", "()Lorg/gradle/api/provider/SetProperty;", "discoveredErrorsFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDiscoveredErrorsFile", "()Lorg/gradle/api/file/RegularFileProperty;", "editorconfigFilesWereChanged", "getEditorconfigFilesWereChanged", "enableExperimental", "getEnableExperimental", "filesToLint", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getFilesToLint", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "formatSnapshot", "getFormatSnapshot", "formatSource", "getFormatSource", "ktLintVersion", "getKtLintVersion", "ktlint-gradle"})
    public static interface KtLintWorkParameters
    extends WorkParameters {
        @NotNull
        public ConfigurableFileCollection getFilesToLint();

        @NotNull
        public Property<Boolean> getAndroid();

        @NotNull
        public SetProperty<String> getDisabledRules();

        @NotNull
        public Property<Boolean> getEnableExperimental();

        @NotNull
        public Property<Boolean> getDebug();

        @NotNull
        public MapProperty<String, String> getAdditionalEditorconfig();

        @NotNull
        public Property<Boolean> getFormatSource();

        @NotNull
        public RegularFileProperty getDiscoveredErrorsFile();

        @NotNull
        public Property<String> getKtLintVersion();

        @NotNull
        public Property<Boolean> getEditorconfigFilesWereChanged();

        @NotNull
        public RegularFileProperty getFormatSnapshot();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lorg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction$FormatTaskSnapshot;", "Ljava/io/Serializable;", "formattedSources", "", "Ljava/io/File;", "", "(Ljava/util/Map;)V", "getFormattedSources", "()Ljava/util/Map;", "Companion", "ktlint-gradle"})
    public static final class FormatTaskSnapshot
    implements Serializable {
        @NotNull
        private final Map<File, byte[]> formattedSources;
        private static final long serialVersionUID = 1L;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Map<File, byte[]> getFormattedSources() {
            return this.formattedSources;
        }

        public FormatTaskSnapshot(@NotNull Map<File, byte[]> formattedSources) {
            Intrinsics.checkNotNullParameter(formattedSources, (String)"formattedSources");
            this.formattedSources = formattedSources;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction$FormatTaskSnapshot$Companion;", "", "()V", "serialVersionUID", "", "contentHash", "", "file", "Ljava/io/File;", "readFromFile", "Lorg/jlleitschuh/gradle/ktlint/worker/KtLintWorkAction$FormatTaskSnapshot;", "snapshotFile", "writeIntoFile", "", "formatSnapshot", "ktlint-gradle"})
        public static final class Companion {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final FormatTaskSnapshot readFromFile(@NotNull File snapshotFile) {
                FormatTaskSnapshot formatTaskSnapshot;
                Intrinsics.checkNotNullParameter((Object)snapshotFile, (String)"snapshotFile");
                Object object = snapshotFile;
                object = new FileInputStream((File)object);
                int n = 8192;
                object = new ObjectInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jlleitschuh.gradle.ktlint.worker.KtLintWorkAction.FormatTaskSnapshot");
                    }
                    formatTaskSnapshot = (FormatTaskSnapshot)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                return formatTaskSnapshot;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void writeIntoFile(@NotNull File snapshotFile, @NotNull FormatTaskSnapshot formatSnapshot) {
                Intrinsics.checkNotNullParameter((Object)snapshotFile, (String)"snapshotFile");
                Intrinsics.checkNotNullParameter((Object)formatSnapshot, (String)"formatSnapshot");
                Object object = snapshotFile;
                object = new FileOutputStream((File)object);
                int n = 8192;
                object = new ObjectOutputStream(object instanceof BufferedOutputStream ? (BufferedOutputStream)object : new BufferedOutputStream((OutputStream)object, n));
                Throwable throwable = null;
                try {
                    ObjectOutputStream it = (ObjectOutputStream)object;
                    boolean bl = false;
                    it.writeObject(formatSnapshot);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final byte[] contentHash(@NotNull File file) {
                byte[] byArray;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Object object = file;
                object = new FileInputStream((File)object);
                int n = 8192;
                object = new MessageDigestCalculatingInputStream(object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n));
                Throwable throwable = null;
                try {
                    MessageDigestCalculatingInputStream it = (MessageDigestCalculatingInputStream)object;
                    boolean bl = false;
                    ByteStreamsKt.readBytes((InputStream)it);
                    byArray = it.getMessageDigest().digest();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"MessageDigestCalculating\u2026igest()\n                }");
                return byArray;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

