/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint.worker;

import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.KtLintCompatibilityKt;
import org.jlleitschuh.gradle.ktlint.reporter.GenericReporterProvider;
import org.jlleitschuh.gradle.ktlint.reporter.ReportersLoaderAdapter;
import org.jlleitschuh.gradle.ktlint.worker.BaselineLoader;
import org.jlleitschuh.gradle.ktlint.worker.KtLintClassesSerializer;
import org.jlleitschuh.gradle.ktlint.worker.LintErrorResult;
import org.jlleitschuh.gradle.ktlint.worker.SerializableLintError;
import org.jlleitschuh.gradle.ktlint.worker.SerializableLintErrorKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jlleitschuh/gradle/ktlint/worker/GenerateReportsWorkAction;", "Lorg/gradle/workers/WorkAction;", "Lorg/jlleitschuh/gradle/ktlint/worker/GenerateReportsWorkAction$GenerateReportsParameters;", "()V", "execute", "", "filePathForReport", "", "file", "Ljava/io/File;", "GenerateReportsParameters", "ktlint-gradle"})
@SourceDebugExtension(value={"SMAP\nGenerateReportsWorkAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenerateReportsWorkAction.kt\norg/jlleitschuh/gradle/ktlint/worker/GenerateReportsWorkAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1#2:82\n1855#3:83\n1855#3,2:84\n1856#3:86\n*E\n*S KotlinDebug\n*F\n+ 1 GenerateReportsWorkAction.kt\norg/jlleitschuh/gradle/ktlint/worker/GenerateReportsWorkAction\n*L\n43#1:83\n49#1,2:84\n43#1:86\n*E\n"})
public abstract class GenerateReportsWorkAction
implements WorkAction<GenerateReportsParameters> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Map<String, List<SerializableLintError>> map;
        Object v6;
        Object object;
        Object object2;
        String currentReporterId;
        List<LintErrorResult> discoveredErrors;
        BaselineLoader baselineLoader;
        block11: {
            Object object3 = ((GenerateReportsParameters)this.getParameters()).getKtLintVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.ktLintVersion.get()");
            baselineLoader = KtLintCompatibilityKt.selectBaselineLoader((String)object3);
            KtLintClassesSerializer ktLintClassesSerializer = KtLintClassesSerializer.Companion.create();
            Object object4 = ((GenerateReportsParameters)this.getParameters()).getDiscoveredErrorsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.discoveredErrorsFile.get()");
            File file = ((RegularFile)object4).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.discoveredErrorsFile.get().asFile");
            discoveredErrors = ktLintClassesSerializer.loadErrors(file);
            Object object5 = ((GenerateReportsParameters)this.getParameters()).getReporterId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"parameters.reporterId.get()");
            currentReporterId = (String)object5;
            Object object6 = ((GenerateReportsParameters)this.getParameters()).getKtLintVersion().get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"parameters.ktLintVersion.get()");
            ReportersLoaderAdapter<?, Serializable, ?, ?> reporterAdapter = KtLintCompatibilityKt.selectReportersLoaderAdapter((String)object6);
            Object object7 = ((GenerateReportsParameters)this.getParameters()).getLoadedReporterProviders().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"parameters.loadedReporterProviders.asFile.get()");
            Iterable iterable = reporterAdapter.loadReporterProviders((File)object7);
            object2 = iterable;
            object = object2.iterator();
            while (object.hasNext()) {
                Object t = object.next();
                GenericReporterProvider it = (GenericReporterProvider)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)currentReporterId)) continue;
                v6 = t;
                break block11;
            }
            v6 = null;
        }
        GenericReporterProvider genericReporterProvider = v6;
        if (genericReporterProvider == null) {
            throw (Throwable)new GradleException("Could not find ReporterProvider \"" + currentReporterId + '\"');
        }
        GenericReporterProvider reporterProvider = genericReporterProvider;
        Object object8 = (RegularFile)((GenerateReportsParameters)this.getParameters()).getBaseline().getOrNull();
        if (object8 != null && (object8 = object8.getAsFile()) != null && (object8 = ((File)object8).getAbsolutePath()) != null) {
            Object it = object2 = object8;
            boolean bl = false;
            map = baselineLoader.loadBaselineRules((String)it);
        } else {
            map = null;
        }
        Map<String, List<SerializableLintError>> baselineRules = map;
        Object object9 = ((GenerateReportsParameters)this.getParameters()).getProjectDirectory().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"parameters.projectDirectory.asFile.get()");
        File projectDir = (File)object9;
        Object object10 = ((GenerateReportsParameters)this.getParameters()).getReporterOutput().get();
        Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"parameters\n             \u2026ut\n                .get()");
        object = new PrintStream(((RegularFile)object10).getAsFile());
        Throwable throwable = null;
        try {
            PrintStream printStream = (PrintStream)object;
            boolean bl = false;
            Object object11 = ((GenerateReportsParameters)this.getParameters()).getReporterOptions().get();
            Intrinsics.checkNotNullExpressionValue((Object)object11, (String)"parameters.reporterOptions.get()");
            Object reporter = reporterProvider.get(printStream, (Map)object11);
            reporter.beforeAll();
            Iterable $this$forEach$iv = discoveredErrors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintErrorResult lintErrorResult = (LintErrorResult)element$iv;
                boolean bl2 = false;
                String filePath = this.filePathForReport(lintErrorResult.getLintedFile());
                Map<String, List<SerializableLintError>> map2 = baselineRules;
                List<SerializableLintError> baselineLintErrors = map2 != null ? map2.get(StringsKt.replace$default((String)FilesKt.toRelativeString((File)lintErrorResult.getLintedFile(), (File)projectDir), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null)) : null;
                reporter.before(filePath);
                Iterable $this$forEach$iv2 = lintErrorResult.getLintErrors();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Pair it = (Pair)element$iv2;
                    boolean bl3 = false;
                    List<SerializableLintError> list = baselineLintErrors;
                    if (list != null && SerializableLintErrorKt.containsLintError(list, (SerializableLintError)it.getFirst())) continue;
                    reporter.onLintError(filePath, (SerializableLintError)it.getFirst(), (Boolean)it.getSecond());
                }
                reporter.after(filePath);
            }
            reporter.afterAll();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    private final String filePathForReport(File file) {
        File rootDir = (File)((GenerateReportsParameters)this.getParameters()).getFilePathsRelativeTo().getOrNull();
        if (rootDir != null) {
            return FilesKt.toRelativeString((File)file, (File)rootDir);
        }
        String string = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        return string;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\fR\u0012\u0010\u0010\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0005R\u0012\u0010\u0012\u001a\u00020\u0013X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\fR\u001e\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lorg/jlleitschuh/gradle/ktlint/worker/GenerateReportsWorkAction$GenerateReportsParameters;", "Lorg/gradle/workers/WorkParameters;", "baseline", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseline", "()Lorg/gradle/api/file/RegularFileProperty;", "discoveredErrorsFile", "getDiscoveredErrorsFile", "filePathsRelativeTo", "Lorg/gradle/api/provider/Property;", "Ljava/io/File;", "getFilePathsRelativeTo", "()Lorg/gradle/api/provider/Property;", "ktLintVersion", "", "getKtLintVersion", "loadedReporterProviders", "getLoadedReporterProviders", "projectDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "reporterId", "getReporterId", "reporterOptions", "Lorg/gradle/api/provider/MapProperty;", "getReporterOptions", "()Lorg/gradle/api/provider/MapProperty;", "reporterOutput", "getReporterOutput", "ktlint-gradle"})
    public static interface GenerateReportsParameters
    extends WorkParameters {
        @NotNull
        public RegularFileProperty getDiscoveredErrorsFile();

        @NotNull
        public RegularFileProperty getLoadedReporterProviders();

        @NotNull
        public Property<String> getReporterId();

        @NotNull
        public RegularFileProperty getReporterOutput();

        @NotNull
        public MapProperty<String, String> getReporterOptions();

        @NotNull
        public Property<String> getKtLintVersion();

        @NotNull
        public RegularFileProperty getBaseline();

        @NotNull
        public DirectoryProperty getProjectDirectory();

        @NotNull
        public Property<File> getFilePathsRelativeTo();
    }
}

