/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.ClassLoaderWorkerSpec;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.PluginUtilKt;
import org.jlleitschuh.gradle.ktlint.reporter.CustomReporter;
import org.jlleitschuh.gradle.ktlint.reporter.ReporterType;
import org.jlleitschuh.gradle.ktlint.tasks.LoadReportersTask;
import org.jlleitschuh.gradle.ktlint.worker.LoadReportersWorkAction;
import org.jlleitschuh.gradle.shadow.net.swiftzer.semver.SemVer;

@CacheableTask
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b!\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010%\u001a\u00020&H\u0007J\f\u0010'\u001a\u00020\u0010*\u00020\u0014H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\n8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00178aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012R\u0016\u0010\u001d\u001a\u00020\u001e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001e8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020\u00178aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jlleitschuh/gradle/ktlint/tasks/LoadReportersTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/workers/WorkerExecutor;Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ProjectLayout;)V", "customReporters", "Lorg/gradle/api/provider/SetProperty;", "Lorg/jlleitschuh/gradle/ktlint/reporter/CustomReporter;", "getCustomReporters$ktlint_gradle", "()Lorg/gradle/api/provider/SetProperty;", "debug", "Lorg/gradle/api/provider/Property;", "", "getDebug$ktlint_gradle", "()Lorg/gradle/api/provider/Property;", "enabledReporters", "Lorg/jlleitschuh/gradle/ktlint/reporter/ReporterType;", "getEnabledReporters$ktlint_gradle", "ktLintClasspath", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getKtLintClasspath$ktlint_gradle", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "ktLintVersion", "", "getKtLintVersion$ktlint_gradle", "loadedReporterProviders", "Lorg/gradle/api/file/RegularFileProperty;", "getLoadedReporterProviders$ktlint_gradle", "()Lorg/gradle/api/file/RegularFileProperty;", "loadedReporters", "getLoadedReporters$ktlint_gradle", "reportersClasspath", "getReportersClasspath$ktlint_gradle", "loadReporters", "", "isAvailable", "Companion", "ktlint-gradle"})
public abstract class LoadReportersTask
extends DefaultTask {
    @NotNull
    private final RegularFileProperty loadedReporters;
    @NotNull
    private final RegularFileProperty loadedReporterProviders;
    private final WorkerExecutor workerExecutor;
    @NotNull
    public static final String TASK_NAME = "loadKtlintReporters";
    @NotNull
    public static final String DESCRIPTION = "Preloads required KtLint reporters.";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getKtLintClasspath$ktlint_gradle();

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getReportersClasspath$ktlint_gradle();

    @Input
    @NotNull
    public abstract Property<Boolean> getDebug$ktlint_gradle();

    @Input
    @NotNull
    public abstract Property<String> getKtLintVersion$ktlint_gradle();

    @Input
    @NotNull
    public abstract SetProperty<ReporterType> getEnabledReporters$ktlint_gradle();

    @Input
    @NotNull
    public abstract SetProperty<CustomReporter> getCustomReporters$ktlint_gradle();

    @OutputFile
    @NotNull
    public final RegularFileProperty getLoadedReporters$ktlint_gradle() {
        return this.loadedReporters;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getLoadedReporterProviders$ktlint_gradle() {
        return this.loadedReporterProviders;
    }

    @TaskAction
    public final void loadReporters() {
        Object object = this.getKtLintVersion$ktlint_gradle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ktLintVersion.get()");
        PluginUtilKt.checkMinimalSupportedKtLintVersion((String)object);
        WorkQueue queue2 = this.workerExecutor.classLoaderIsolation(new Action(this){
            final /* synthetic */ LoadReportersTask this$0;

            public final void execute(@NotNull ClassLoaderWorkerSpec $this$classLoaderIsolation) {
                Intrinsics.checkNotNullParameter((Object)$this$classLoaderIsolation, (String)"$receiver");
                $this$classLoaderIsolation.getClasspath().from(new Object[]{this.this$0.getKtLintClasspath$ktlint_gradle(), this.this$0.getReportersClasspath$ktlint_gradle()});
            }
            {
                this.this$0 = loadReportersTask;
            }
        });
        queue2.submit(LoadReportersWorkAction.class, new Action(this){
            final /* synthetic */ LoadReportersTask this$0;

            public final void execute(@NotNull LoadReportersWorkAction.LoadReportersParameters $this$submit) {
                Intrinsics.checkNotNullParameter((Object)$this$submit, (String)"$receiver");
                LoadReportersTask task = this.this$0;
                $this$submit.getDebug().set((Provider)task.getDebug$ktlint_gradle());
                $this$submit.getEnabledReporters().set(task.getEnabledReporters$ktlint_gradle().map(new Transformer(this){
                    final /* synthetic */ loadReporters.1 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final List<ReporterType> transform(@NotNull Set<ReporterType> reporters) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(reporters, (String)"reporters");
                        Iterable $this$filter$iv = reporters;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            ReporterType it = (ReporterType)element$iv$iv;
                            boolean bl = false;
                            LoadReportersTask loadReportersTask = this.this$0.this$0;
                            ReporterType reporterType = it;
                            Intrinsics.checkNotNullExpressionValue((Object)reporterType, (String)"it");
                            if (!LoadReportersTask.access$isAvailable(loadReportersTask, reporterType)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                $this$submit.getCustomReporters().set((Provider)task.getCustomReporters$ktlint_gradle());
                $this$submit.getLoadedReporters().set((Provider)task.getLoadedReporters$ktlint_gradle());
                $this$submit.getLoadedReporterProviders().set((Provider)task.getLoadedReporterProviders$ktlint_gradle());
                $this$submit.getKtLintVersion().set((Provider)task.getKtLintVersion$ktlint_gradle());
            }
            {
                this.this$0 = loadReportersTask;
            }
        });
    }

    private final boolean isAvailable(ReporterType $this$isAvailable) {
        Object object = this.getKtLintVersion$ktlint_gradle().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ktLintVersion.get()");
        return SemVer.Companion.parse((String)object).compareTo($this$isAvailable.getAvailableSinceVersion()) >= 0;
    }

    @Inject
    public LoadReportersTask(@NotNull WorkerExecutor workerExecutor, @NotNull ObjectFactory objectFactory, @NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.workerExecutor = workerExecutor;
        RegularFileProperty regularFileProperty = objectFactory.fileProperty().convention(PluginUtilKt.intermediateResultsBuildDir(projectLayout, "reporters.bin"));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objectFactory.fileProper\u2026ir(\"reporters.bin\")\n    )");
        this.loadedReporters = regularFileProperty;
        RegularFileProperty regularFileProperty2 = objectFactory.fileProperty().convention(PluginUtilKt.intermediateResultsBuildDir(projectLayout, "reporterProviders.bin"));
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"objectFactory.fileProper\u2026rterProviders.bin\")\n    )");
        this.loadedReporterProviders = regularFileProperty2;
    }

    public static final /* synthetic */ boolean access$isAvailable(LoadReportersTask $this, ReporterType $this$access_u24isAvailable) {
        return $this.isAvailable($this$access_u24isAvailable);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jlleitschuh/gradle/ktlint/tasks/LoadReportersTask$Companion;", "", "()V", "DESCRIPTION", "", "TASK_NAME", "ktlint-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

