/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.configuration.ConsoleOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.PluginUtilKt;
import org.jlleitschuh.gradle.shadow.net.swiftzer.semver.SemVer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0001H\u0000\u001a\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001f\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00172\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u001eH\u0082\u0010\u001a\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 *\u00020\"2\u0006\u0010#\u001a\u00020\u0001H\u0000\u001a\f\u0010$\u001a\u00020%*\u00020&H\u0000\u001a\f\u0010'\u001a\u00020%*\u00020\u0017H\u0000\u001a(\u0010(\u001a\u00020\u0013*\u00020)2\u0006\u0010*\u001a\u00020%2\u0012\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\f0,H\u0000\u001a?\u0010-\u001a\b\u0012\u0004\u0012\u0002H/0.\"\u0006\b\u0000\u0010/\u0018\u0001*\u0002002\u001f\b\u0002\u00101\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0.\u0012\u0004\u0012\u00020\u001302\u00a2\u0006\u0002\b3H\u0080\b\u00f8\u0001\u0000\u001a`\u00104\u001a\b\u0012\u0004\u0012\u0002H/05\"\n\b\u0000\u0010/\u0018\u0001*\u000206*\u00020&2\u0006\u00107\u001a\u00020\u00012\u0014\b\u0002\u00108\u001a\n\u0012\u0006\b\u0001\u0012\u00020:09\"\u00020:2\u0019\b\b\u00101\u001a\u0013\u0012\u0004\u0012\u0002H/\u0012\u0004\u0012\u00020\u001302\u00a2\u0006\u0002\b3H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;\u001a?\u0010<\u001a\b\u0012\u0004\u0012\u0002H/0=\"\u0006\b\u0000\u0010/\u0018\u0001*\u0002002\u001f\b\u0002\u00101\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H/0=\u0012\u0004\u0012\u00020\u001302\u00a2\u0006\u0002\b3H\u0080\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\b\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006>"}, d2={"CHECK_PARENT_TASK_NAME", "", "EDITOR_CONFIG_FILE_NAME", "FORMATTING_GROUP", "FORMAT_PARENT_TASK_NAME", "HELP_GROUP", "INSTALL_GIT_HOOK_CHECK_TASK", "INSTALL_GIT_HOOK_FORMAT_TASK", "INTERMEDIATE_RESULTS_PATH", "getINTERMEDIATE_RESULTS_PATH", "()Ljava/lang/String;", "KOTLIN_EXTENSIONS", "", "getKOTLIN_EXTENSIONS", "()Ljava/util/List;", "VERIFICATION_GROUP", "editorConfigRootRegex", "Lkotlin/text/Regex;", "checkMinimalSupportedKtLintVersion", "", "ktLintVersion", "getEditorConfigFiles", "", "Ljava/nio/file/Path;", "currentProjectDir", "additionalEditorconfigFile", "Lorg/gradle/api/file/RegularFileProperty;", "searchEditorConfigFiles", "projectPath", "result", "", "intermediateResultsBuildDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "Lorg/gradle/api/file/ProjectLayout;", "resultsFile", "isConsolePlain", "", "Lorg/gradle/api/Project;", "isRootEditorConfig", "logKtLintDebugMessage", "Lorg/gradle/api/logging/Logger;", "debugIsEnabled", "logProducer", "Lkotlin/Function0;", "property", "Lorg/gradle/api/provider/Property;", "T", "Lorg/gradle/api/model/ObjectFactory;", "configuration", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "registerTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "name", "constructorArguments", "", "", "(Lorg/gradle/api/Project;Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Lorg/gradle/api/tasks/TaskProvider;", "setProperty", "Lorg/gradle/api/provider/SetProperty;", "ktlint-gradle"})
@SourceDebugExtension(value={"SMAP\nPluginUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginUtil.kt\norg/jlleitschuh/gradle/ktlint/PluginUtilKt\n+ 2 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n+ 3 FileReadWrite.kt\nkotlin/io/FilesKt__FileReadWriteKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n263#2:135\n230#3,2:136\n1#4:138\n179#5,2:139\n1855#6,2:141\n*E\n*S KotlinDebug\n*F\n+ 1 PluginUtil.kt\norg/jlleitschuh/gradle/ktlint/PluginUtilKt\n*L\n30#1:135\n79#1,2:136\n79#1:138\n80#1,2:139\n120#1,2:141\n*E\n"})
public final class PluginUtilKt {
    @NotNull
    public static final String EDITOR_CONFIG_FILE_NAME = ".editorconfig";
    private static final Regex editorConfigRootRegex;
    @NotNull
    public static final String VERIFICATION_GROUP = "verification";
    @NotNull
    public static final String FORMATTING_GROUP = "Formatting";
    @NotNull
    public static final String HELP_GROUP = "help";
    @NotNull
    public static final String CHECK_PARENT_TASK_NAME = "ktlintCheck";
    @NotNull
    public static final String FORMAT_PARENT_TASK_NAME = "ktlintFormat";
    @NotNull
    public static final String INSTALL_GIT_HOOK_CHECK_TASK = "addKtlintCheckGitPreCommitHook";
    @NotNull
    public static final String INSTALL_GIT_HOOK_FORMAT_TASK = "addKtlintFormatGitPreCommitHook";
    @NotNull
    private static final List<String> KOTLIN_EXTENSIONS;
    @NotNull
    private static final String INTERMEDIATE_RESULTS_PATH;

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ <T extends Task> TaskProvider<T> registerTask(Project $this$registerTask, String name, Object[] constructorArguments, Function1<? super T, Unit> configuration) {
        void $this$register$iv;
        int $i$f$registerTask = 0;
        Intrinsics.checkNotNullParameter((Object)$this$registerTask, (String)"$this$registerTask");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)constructorArguments, (String)"constructorArguments");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        TaskContainer taskContainer = $this$registerTask.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
        TaskContainer taskContainer2 = taskContainer;
        Object[] arguments$iv = Arrays.copyOf(constructorArguments, constructorArguments.length);
        boolean $i$f$register = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        TaskProvider taskProvider = $this$register$iv.register(name, Task.class, Arrays.copyOf(arguments$iv, arguments$iv.length));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, *arguments)");
        taskContainer2 = taskProvider;
        TaskProvider $this$apply = (TaskProvider)taskContainer2;
        boolean bl = false;
        Function1<? super T, Unit> function1 = configuration;
        $this$apply.configure(new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                this.function = function1;
            }

            public final /* synthetic */ void execute(Object p0) {
                Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0), (String)"invoke(...)");
            }
        });
        return (TaskProvider)taskContainer2;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ TaskProvider registerTask$default(Project $this$registerTask, String name, Object[] constructorArguments, Function1 configuration, int n, Object object) {
        void $this$register$iv;
        if ((n & 2) != 0) {
            constructorArguments = new Object[]{};
        }
        boolean $i$f$registerTask = false;
        Intrinsics.checkNotNullParameter((Object)$this$registerTask, (String)"$this$registerTask");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)constructorArguments, (String)"constructorArguments");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        TaskContainer taskContainer = $this$registerTask.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
        object = taskContainer;
        Object[] arguments$iv = Arrays.copyOf(constructorArguments, constructorArguments.length);
        boolean $i$f$register = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        TaskProvider taskProvider = $this$register$iv.register(name, Task.class, Arrays.copyOf(arguments$iv, arguments$iv.length));
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, *arguments)");
        object = taskProvider;
        TaskProvider $this$apply = (TaskProvider)object;
        boolean bl = false;
        Function1 function1 = configuration;
        $this$apply.configure(new /* invalid duplicate definition of identical inner class */);
        return (TaskProvider)object;
    }

    @NotNull
    public static final Set<Path> getEditorConfigFiles(@NotNull Path currentProjectDir, @NotNull RegularFileProperty additionalEditorconfigFile) {
        Intrinsics.checkNotNullParameter((Object)currentProjectDir, (String)"currentProjectDir");
        Intrinsics.checkNotNullParameter((Object)additionalEditorconfigFile, (String)"additionalEditorconfigFile");
        Set result = new LinkedHashSet();
        PluginUtilKt.searchEditorConfigFiles(currentProjectDir, result);
        if (additionalEditorconfigFile.isPresent()) {
            Path path = ((File)additionalEditorconfigFile.getAsFile().get()).toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"additionalEditorconfigFile.asFile.get().toPath()");
            result.add(path);
        }
        return result;
    }

    private static final void searchEditorConfigFiles(Path projectPath, Set<Path> result) {
        while (true) {
            Path parentDir;
            Path editorConfigFC;
            if (Files.exists(editorConfigFC = projectPath.resolve(EDITOR_CONFIG_FILE_NAME), new LinkOption[0])) {
                Path path = editorConfigFC.toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"editorConfigFC.toAbsolutePath()");
                result.add(path);
            }
            if ((parentDir = projectPath.getParent()) == null) break;
            Path path = editorConfigFC;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"editorConfigFC");
            if (PluginUtilKt.isRootEditorConfig(path)) break;
            projectPath = parentDir;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final boolean isRootEditorConfig(@NotNull Path $this$isRootEditorConfig) {
        void $this$useLines$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isRootEditorConfig, (String)"$this$isRootEditorConfig");
        if (!Files.exists($this$isRootEditorConfig, new LinkOption[0]) || !Files.isReadable($this$isRootEditorConfig)) {
            return false;
        }
        File file = $this$isRootEditorConfig.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile()");
        File $this$useLines_u24default$iv = file;
        Charset charset$iv = Charsets.UTF_8;
        File file2 = $this$useLines_u24default$iv;
        Charset charset$iv$iv = charset$iv;
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv$iv;
        int n = 8192;
        Reader reader = closeable;
        reader = new InputStreamReader((InputStream)new FileInputStream((File)((Object)reader)), charset$iv$iv);
        closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
        Throwable throwable = null;
        try {
            Object v1;
            block7: {
                BufferedReader it$iv$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv$iv);
                boolean bl2 = false;
                Sequence $this$firstOrNull$iv = lines;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Regex regex = editorConfigRootRegex;
                    CharSequence charSequence = it;
                    if (!regex.containsMatchIn(charSequence)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            String isRoot = v1;
            boolean bl = isRoot != null;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final List<String> getKOTLIN_EXTENSIONS() {
        return KOTLIN_EXTENSIONS;
    }

    @NotNull
    public static final String getINTERMEDIATE_RESULTS_PATH() {
        return INTERMEDIATE_RESULTS_PATH;
    }

    public static final /* synthetic */ <T> Property<T> property(ObjectFactory $this$property, Function1<? super Property<T>, Unit> configuration) {
        int $i$f$property = 0;
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"$this$property");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        Property property2 = $this$property.property(Object.class);
        configuration.invoke((Object)property2);
        Property property3 = property2;
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java).apply(configuration)");
        return property3;
    }

    public static /* synthetic */ Property property$default(ObjectFactory $this$property, Function1 configuration, int n, Object object) {
        if ((n & 1) != 0) {
            configuration = property.1.INSTANCE;
        }
        boolean $i$f$property = false;
        Intrinsics.checkNotNullParameter((Object)$this$property, (String)"$this$property");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        object = $this$property.property(Object.class);
        configuration.invoke(object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"property(T::class.java).apply(configuration)");
        return (Property)object2;
    }

    public static final /* synthetic */ <T> SetProperty<T> setProperty(ObjectFactory $this$setProperty, Function1<? super SetProperty<T>, Unit> configuration) {
        int $i$f$setProperty = 0;
        Intrinsics.checkNotNullParameter((Object)$this$setProperty, (String)"$this$setProperty");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        SetProperty setProperty2 = $this$setProperty.setProperty(Object.class);
        configuration.invoke((Object)setProperty2);
        SetProperty setProperty3 = setProperty2;
        Intrinsics.checkNotNullExpressionValue((Object)setProperty3, (String)"setProperty(T::class.java).apply(configuration)");
        return setProperty3;
    }

    public static /* synthetic */ SetProperty setProperty$default(ObjectFactory $this$setProperty, Function1 configuration, int n, Object object) {
        if ((n & 1) != 0) {
            configuration = setProperty.1.INSTANCE;
        }
        boolean $i$f$setProperty = false;
        Intrinsics.checkNotNullParameter((Object)$this$setProperty, (String)"$this$setProperty");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        object = $this$setProperty.setProperty(Object.class);
        configuration.invoke(object);
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"setProperty(T::class.java).apply(configuration)");
        return (SetProperty)object2;
    }

    public static final boolean isConsolePlain(@NotNull Project $this$isConsolePlain) {
        Intrinsics.checkNotNullParameter((Object)$this$isConsolePlain, (String)"$this$isConsolePlain");
        Gradle gradle = $this$isConsolePlain.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkNotNullExpressionValue((Object)startParameter, (String)"gradle.startParameter");
        return startParameter.getConsoleOutput() == ConsoleOutput.Plain;
    }

    @NotNull
    public static final Provider<RegularFile> intermediateResultsBuildDir(@NotNull ProjectLayout $this$intermediateResultsBuildDir, @NotNull String resultsFile) {
        Intrinsics.checkNotNullParameter((Object)$this$intermediateResultsBuildDir, (String)"$this$intermediateResultsBuildDir");
        Intrinsics.checkNotNullParameter((Object)resultsFile, (String)"resultsFile");
        Provider provider = $this$intermediateResultsBuildDir.getBuildDirectory().file(INTERMEDIATE_RESULTS_PATH + resultsFile);
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"buildDirectory.file(\"$IN\u2026ESULTS_PATH$resultsFile\")");
        return provider;
    }

    public static final void logKtLintDebugMessage(@NotNull Logger $this$logKtLintDebugMessage, boolean debugIsEnabled, @NotNull Function0<? extends List<String>> logProducer) {
        Intrinsics.checkNotNullParameter((Object)$this$logKtLintDebugMessage, (String)"$this$logKtLintDebugMessage");
        Intrinsics.checkNotNullParameter(logProducer, (String)"logProducer");
        if (debugIsEnabled) {
            Iterable $this$forEach$iv = (Iterable)logProducer.invoke();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                $this$logKtLintDebugMessage.warn("[KtLint DEBUG] " + it);
            }
        }
    }

    public static final void checkMinimalSupportedKtLintVersion(@NotNull String ktLintVersion) {
        Intrinsics.checkNotNullParameter((Object)ktLintVersion, (String)"ktLintVersion");
        if (SemVer.Companion.parse(ktLintVersion).compareTo(new SemVer(0, 47, 1, null, null, 24, null)) < 0) {
            throw (Throwable)new GradleException("KtLint versions less than 0.47.1 are not supported. " + "Detected KtLint version: " + ktLintVersion + '.');
        }
    }

    static {
        String string = "^root\\s?=\\s?true";
        editorConfigRootRegex = new Regex(string);
        KOTLIN_EXTENSIONS = CollectionsKt.listOf((Object[])new String[]{"kt", "kts"});
        INTERMEDIATE_RESULTS_PATH = "intermediates" + File.separator + "ktLint" + File.separator;
    }
}

