/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.GitHookKt;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.Repository;
import org.jlleitschuh.gradle.shadow.org.eclipse.jgit.lib.RepositoryBuilder;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0007R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\r8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00020\r8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\b8AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jlleitschuh/gradle/ktlint/KtlintInstallGitHookTask;", "Lorg/gradle/api/DefaultTask;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/file/ProjectLayout;)V", "hookName", "Lorg/gradle/api/provider/Property;", "", "getHookName$ktlint_gradle", "()Lorg/gradle/api/provider/Property;", "projectDir", "Lorg/gradle/api/file/DirectoryProperty;", "getProjectDir$ktlint_gradle", "()Lorg/gradle/api/file/DirectoryProperty;", "rootDirectory", "getRootDirectory$ktlint_gradle", "shouldUpdateCommit", "", "getShouldUpdateCommit$ktlint_gradle", "taskName", "getTaskName$ktlint_gradle", "installHook", "", "ktlint-gradle"})
public class KtlintInstallGitHookTask
extends DefaultTask {
    @NotNull
    private final Property<String> taskName;
    @NotNull
    private final Property<Boolean> shouldUpdateCommit;
    @NotNull
    private final Property<String> hookName;
    @NotNull
    private final DirectoryProperty projectDir;
    @NotNull
    private final DirectoryProperty rootDirectory;

    @Input
    @NotNull
    public final Property<String> getTaskName$ktlint_gradle() {
        return this.taskName;
    }

    @Input
    @NotNull
    public final Property<Boolean> getShouldUpdateCommit$ktlint_gradle() {
        return this.shouldUpdateCommit;
    }

    @Input
    @NotNull
    public final Property<String> getHookName$ktlint_gradle() {
        return this.hookName;
    }

    @InputDirectory
    @NotNull
    public final DirectoryProperty getProjectDir$ktlint_gradle() {
        return this.projectDir;
    }

    @InputDirectory
    @NotNull
    public final DirectoryProperty getRootDirectory$ktlint_gradle() {
        return this.rootDirectory;
    }

    @TaskAction
    public final void installHook() {
        Object repo;
        RepositoryBuilder repositoryBuilder = new RepositoryBuilder();
        Object object = this.projectDir.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectDir.get()");
        Object r = repo = ((RepositoryBuilder)((RepositoryBuilder)repositoryBuilder.findGitDir(((Directory)object).getAsFile())).setMustExist(false)).build();
        Intrinsics.checkNotNullExpressionValue(r, (String)"repo");
        if (!((Repository)r).getObjectDatabase().exists()) {
            this.getLogger().warn("No git folder was found!");
            return;
        }
        this.getLogger().info(".git directory path: " + ((Repository)repo).getDirectory());
        File file = ((Repository)repo).getDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"repo.directory");
        File gitHookDirectory = FilesKt.resolve((File)file, (String)"hooks");
        if (!gitHookDirectory.exists()) {
            this.getLogger().info("git hooks directory doesn't exist, creating one");
            gitHookDirectory.mkdir();
        }
        File file2 = ((Repository)repo).getDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"repo.directory");
        File gitHookFile = FilesKt.resolve((File)file2, (String)("hooks/" + (String)this.hookName.get()));
        this.getLogger().info("Hook file: " + gitHookFile);
        if (!gitHookFile.exists()) {
            gitHookFile.createNewFile();
            gitHookFile.setExecutable(true);
        }
        Object object2 = this.rootDirectory.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"rootDirectory.get()");
        File file3 = ((Directory)object2).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"rootDirectory.get().asFile");
        File file4 = ((Repository)repo).getWorkTree();
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"repo.workTree");
        String gradleRootDirPrefix = FilesKt.relativeTo((File)file3, (File)file4).getPath();
        if (gitHookFile.length() == 0L) {
            StringBuilder stringBuilder = new StringBuilder().append(GitHookKt.getShShebang()).append("######## KTLINT-GRADLE HOOK START ########\n");
            Object object3 = this.taskName.get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"taskName.get()");
            String string = (String)object3;
            Object object4 = this.shouldUpdateCommit.get();
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"shouldUpdateCommit.get()");
            boolean bl = (Boolean)object4;
            String string2 = gradleRootDirPrefix;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gradleRootDirPrefix");
            FilesKt.writeText$default((File)gitHookFile, (String)stringBuilder.append(GitHookKt.generateGitHook(string, bl, string2)).append("######## KTLINT-GRADLE HOOK END ########\n").toString(), null, (int)2, null);
            return;
        }
        String hookContent = FilesKt.readText$default((File)gitHookFile, null, (int)1, null);
        if (StringsKt.contains$default((CharSequence)hookContent, (CharSequence)"######## KTLINT-GRADLE HOOK START ########\n", (boolean)false, (int)2, null)) {
            int startTagIndex = StringsKt.indexOf$default((CharSequence)hookContent, (String)"######## KTLINT-GRADLE HOOK START ########\n", (int)0, (boolean)false, (int)6, null);
            int endTagIndex = StringsKt.indexOf$default((CharSequence)hookContent, (String)"######## KTLINT-GRADLE HOOK END ########\n", (int)0, (boolean)false, (int)6, null);
            String string = hookContent;
            StringBuilder stringBuilder = new StringBuilder().append("######## KTLINT-GRADLE HOOK START ########\n");
            Object object5 = this.taskName.get();
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"taskName.get()");
            String string3 = (String)object5;
            Object object6 = this.shouldUpdateCommit.get();
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"shouldUpdateCommit.get()");
            boolean bl = (Boolean)object6;
            String string4 = gradleRootDirPrefix;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"gradleRootDirPrefix");
            CharSequence charSequence = stringBuilder.append(GitHookKt.generateGitHook(string3, bl, string4)).toString();
            hookContent = ((Object)StringsKt.replaceRange((CharSequence)string, (int)startTagIndex, (int)endTagIndex, (CharSequence)charSequence)).toString();
            FilesKt.writeText$default((File)gitHookFile, (String)hookContent, null, (int)2, null);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("######## KTLINT-GRADLE HOOK START ########\n");
            Object object7 = this.taskName.get();
            Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"taskName.get()");
            String string = (String)object7;
            Object object8 = this.shouldUpdateCommit.get();
            Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"shouldUpdateCommit.get()");
            boolean bl = (Boolean)object8;
            String string5 = gradleRootDirPrefix;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"gradleRootDirPrefix");
            FilesKt.appendText$default((File)gitHookFile, (String)stringBuilder.append(GitHookKt.generateGitHook(string, bl, string5)).append("######## KTLINT-GRADLE HOOK END ########\n").toString(), null, (int)2, null);
        }
    }

    @Inject
    public KtlintInstallGitHookTask(@NotNull ObjectFactory objectFactory, @NotNull ProjectLayout projectLayout) {
        DirectoryProperty $this$apply;
        DirectoryProperty directoryProperty;
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Property property2 = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"objectFactory.property(String::class.java)");
        this.taskName = property2;
        Property property3 = objectFactory.property(Boolean.TYPE).convention((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"objectFactory.property(B\u2026s.java).convention(false)");
        this.shouldUpdateCommit = property3;
        Property property4 = objectFactory.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"objectFactory.property(String::class.java)");
        this.hookName = property4;
        DirectoryProperty directoryProperty2 = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objectFactory.directoryProperty()");
        DirectoryProperty directoryProperty3 = directoryProperty = directoryProperty2;
        KtlintInstallGitHookTask ktlintInstallGitHookTask = this;
        boolean bl = false;
        $this$apply.set((Object)projectLayout.getProjectDirectory());
        Unit unit = Unit.INSTANCE;
        ktlintInstallGitHookTask.projectDir = directoryProperty;
        DirectoryProperty directoryProperty4 = objectFactory.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty4, (String)"objectFactory.directoryProperty()");
        $this$apply = directoryProperty = directoryProperty4;
        ktlintInstallGitHookTask = this;
        boolean bl2 = false;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        $this$apply.set(project.getRootDir());
        unit = Unit.INSTANCE;
        ktlintInstallGitHookTask.rootDirectory = directoryProperty;
    }
}

