/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint;

import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.reporter.ReportersLoaderAdapter;
import org.jlleitschuh.gradle.ktlint.reporter.ReportersProviderLoader;
import org.jlleitschuh.gradle.ktlint.reporter.ReportersProviderV2Loader;
import org.jlleitschuh.gradle.ktlint.worker.BaselineLoader;
import org.jlleitschuh.gradle.ktlint.worker.BaselineLoader47;
import org.jlleitschuh.gradle.ktlint.worker.BaselineLoader48;
import org.jlleitschuh.gradle.ktlint.worker.BaselineLoader49;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation100;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation47;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation48;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation49;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocation50;
import org.jlleitschuh.gradle.ktlint.worker.KtLintInvocationFactory;
import org.jlleitschuh.gradle.shadow.net.swiftzer.semver.SemVer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\u0006\u001a\u0016\u0012\u0002\b\u0003\u0012\u0006\b\u0001\u0012\u00020\b\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\t"}, d2={"selectBaselineLoader", "Lorg/jlleitschuh/gradle/ktlint/worker/BaselineLoader;", "version", "", "selectInvocation", "Lorg/jlleitschuh/gradle/ktlint/worker/KtLintInvocationFactory;", "selectReportersLoaderAdapter", "Lorg/jlleitschuh/gradle/ktlint/reporter/ReportersLoaderAdapter;", "Ljava/io/Serializable;", "ktlint-gradle"})
public final class KtLintCompatibilityKt {
    @NotNull
    public static final KtLintInvocationFactory selectInvocation(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        SemVer semVer = SemVer.Companion.parse(version);
        return semVer.getMajor() == 0 ? (semVer.getMinor() == 47 ? (KtLintInvocationFactory)KtLintInvocation47.Factory : (semVer.getMinor() == 48 ? (KtLintInvocationFactory)KtLintInvocation48.Factory : (semVer.getMinor() == 49 ? (KtLintInvocationFactory)KtLintInvocation49.Factory : (KtLintInvocationFactory)KtLintInvocation50.Factory))) : (KtLintInvocationFactory)KtLintInvocation100.Factory;
    }

    @NotNull
    public static final BaselineLoader selectBaselineLoader(@NotNull String version) {
        BaselineLoader baselineLoader;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        SemVer semVer = SemVer.Companion.parse(version);
        if (semVer.getMajor() == 0) {
            if (semVer.getMinor() == 47) {
                baselineLoader = new BaselineLoader47();
            } else if (semVer.getMinor() == 48) {
                baselineLoader = new BaselineLoader48();
            } else {
                BaselineLoader49 baselineLoader49;
                if (semVer.getMinor() == 49) {
                    if (semVer.getPatch() == 0) {
                        throw (Throwable)new GradleException("ktlint 0.49.0 is incompatible with ktlint-gradle. Please upgrade to 0.49.1+");
                    }
                    baselineLoader49 = new BaselineLoader49();
                } else {
                    baselineLoader49 = new BaselineLoader49();
                }
                baselineLoader = baselineLoader49;
            }
        } else {
            baselineLoader = new BaselineLoader49();
        }
        return baselineLoader;
    }

    @NotNull
    public static final ReportersLoaderAdapter<?, ? extends Serializable, ?, ?> selectReportersLoaderAdapter(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        SemVer semVer = SemVer.Companion.parse(version);
        return semVer.getMajor() == 0 ? (semVer.getMinor() < 49 ? (ReportersLoaderAdapter)new ReportersProviderLoader() : (ReportersLoaderAdapter)new ReportersProviderV2Loader()) : (ReportersLoaderAdapter)new ReportersProviderV2Loader();
    }
}

