/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.GitHookKt;
import org.jlleitschuh.gradle.ktlint.KtlintInstallGitHookTask;
import org.jlleitschuh.gradle.ktlint.KtlintPlugin;
import org.jlleitschuh.gradle.ktlint.tasks.BaseKtLintCheckTask;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a \u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0001H\u0001\u001a\u0018\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0000\u001a\f\u0010\u0013\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0011*\u00020\u0012H\u0002\u001a\f\u0010\u0015\u001a\u00020\u0011*\u00020\u0016H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"FILTER_INCLUDE_PROPERTY_NAME", "", "NF", "endHookSection", "shShebang", "getShShebang", "()Ljava/lang/String;", "startHookSection", "generateGitCommand", "gradleRootDirPrefix", "generateGitHook", "taskName", "shouldUpdateCommit", "", "generateGradleCommand", "postCheck", "addGitHookTasks", "", "Lorg/jlleitschuh/gradle/ktlint/KtlintPlugin$PluginHolder;", "addInstallGitHookCheckTask", "addInstallGitHookFormatTask", "applyGitFilter", "Lorg/jlleitschuh/gradle/ktlint/tasks/BaseKtLintCheckTask;", "ktlint-gradle"})
@SourceDebugExtension(value={"SMAP\nGitHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHook.kt\norg/jlleitschuh/gradle/ktlint/GitHookKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,251:1\n766#2:252\n857#2,2:253\n1549#2:255\n1620#2,3:256\n*E\n*S KotlinDebug\n*F\n+ 1 GitHook.kt\norg/jlleitschuh/gradle/ktlint/GitHookKt\n*L\n230#1:252\n230#1,2:253\n231#1:255\n231#1,3:256\n*E\n"})
public final class GitHookKt {
    @NotNull
    public static final String FILTER_INCLUDE_PROPERTY_NAME = "internalKtlintGitFilter";
    @Language(value="Bash")
    @NotNull
    private static final String shShebang = "#!/bin/sh\n";
    @NotNull
    public static final String startHookSection = "######## KTLINT-GRADLE HOOK START ########\n";
    @NotNull
    public static final String endHookSection = "######## KTLINT-GRADLE HOOK END ########\n";
    @NotNull
    public static final String NF = "$NF";

    @NotNull
    public static final String getShShebang() {
        return shShebang;
    }

    private static final String generateGradleCommand(String taskName, String gradleRootDirPrefix) {
        CharSequence charSequence = gradleRootDirPrefix;
        String gradleCommand = charSequence.length() > 0 ? "./" + gradleRootDirPrefix + "/gradlew -p ./" + gradleRootDirPrefix : "./gradlew";
        return gradleCommand + " --quiet " + taskName + " -PinternalKtlintGitFilter=\"$CHANGED_FILES\"";
    }

    private static final String generateGitCommand(String gradleRootDirPrefix) {
        CharSequence charSequence = gradleRootDirPrefix;
        return charSequence.length() == 0 ? "git --no-pager diff --name-status --no-color --cached" : "git --no-pager diff --name-status --no-color --cached -- " + gradleRootDirPrefix + '/';
    }

    private static final String postCheck(boolean shouldUpdateCommit) {
        return shouldUpdateCommit ? "\n    echo \"$CHANGED_FILES\" | while read -r file; do\n        if [ -f $file ]; then\n            git add $file\n        fi\n    done\n    " : "";
    }

    @Language(value="Sh")
    @NotNull
    public static final String generateGitHook(@NotNull String taskName, boolean shouldUpdateCommit, @NotNull String gradleRootDirPrefix) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter((Object)gradleRootDirPrefix, (String)"gradleRootDirPrefix");
        return StringsKt.trimIndent((String)("\n\n    CHANGED_FILES=\"$(" + GitHookKt.generateGitCommand(gradleRootDirPrefix) + " | awk '$1 != \"D\" && $NF ~ /\\.kts?$/ { print $NF }')\"\n\n    if [ -z \"$CHANGED_FILES\" ]; then\n        echo \"No Kotlin staged files.\"\n        exit 0\n    fi;\n\n    echo \"Running ktlint over these files:\"\n    echo \"$CHANGED_FILES\"\n\n    diff=.git/unstaged-ktlint-git-hook.diff\n    git diff --color=never > $diff\n    if [ -s $diff ]; then\n      git apply -R $diff\n    fi\n\n    " + GitHookKt.generateGradleCommand(taskName, gradleRootDirPrefix) + "\n    gradle_command_exit_code=$?\n\n    echo \"Completed ktlint run.\"\n    " + GitHookKt.postCheck(shouldUpdateCommit) + "\n\n    if [ -s $diff ]; then\n      git apply --ignore-whitespace $diff\n    fi\n    rm $diff\n    unset diff\n\n    echo \"Completed ktlint hook.\"\n    exit $gradle_command_exit_code\n\n    "));
    }

    public static final void addGitHookTasks(@NotNull KtlintPlugin.PluginHolder $this$addGitHookTasks) {
        Intrinsics.checkNotNullParameter((Object)$this$addGitHookTasks, (String)"$this$addGitHookTasks");
        if (Intrinsics.areEqual((Object)$this$addGitHookTasks.getTarget().getRootProject(), (Object)$this$addGitHookTasks.getTarget())) {
            GitHookKt.addInstallGitHookFormatTask($this$addGitHookTasks);
            GitHookKt.addInstallGitHookCheckTask($this$addGitHookTasks);
        }
    }

    private static final void addInstallGitHookFormatTask(KtlintPlugin.PluginHolder $this$addInstallGitHookFormatTask) {
        $this$addInstallGitHookFormatTask.getTarget().getTasks().register("addKtlintFormatGitPreCommitHook", KtlintInstallGitHookTask.class, (Action)addInstallGitHookFormatTask.1.INSTANCE);
    }

    private static final void addInstallGitHookCheckTask(KtlintPlugin.PluginHolder $this$addInstallGitHookCheckTask) {
        $this$addInstallGitHookCheckTask.getTarget().getTasks().register("addKtlintCheckGitPreCommitHook", KtlintInstallGitHookTask.class, (Action)addInstallGitHookCheckTask.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public static final void applyGitFilter(@NotNull BaseKtLintCheckTask $this$applyGitFilter) {
        void $this$mapTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$applyGitFilter), (String)"$this$applyGitFilter");
        Project project = $this$applyGitFilter.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Path path = project.getRootDir().toPath();
        Project project2 = $this$applyGitFilter.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        String projectRelativePath = ((Object)path.relativize(project2.getProjectDir().toPath())).toString();
        Object object = $this$applyGitFilter.getProject().property(FILTER_INCLUDE_PROPERTY_NAME);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)((String)object), (char[])new char[]{'\n'}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)projectRelativePath, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = StringsKt.replace$default((String)it, (String)"\\", (String)"/", (boolean)false, (int)4, null);
            collection.add(string);
        }
        List filesToInclude = (List)destination$iv$iv;
        Collection collection = filesToInclude;
        if (!collection.isEmpty()) {
            $this$applyGitFilter.include(new Spec(filesToInclude){
                final /* synthetic */ List $filesToInclude;

                public final boolean isSatisfiedBy(FileTreeElement fileTreeElement) {
                    boolean bl;
                    block5: {
                        FileTreeElement fileTreeElement2 = fileTreeElement;
                        Intrinsics.checkNotNullExpressionValue((Object)fileTreeElement2, (String)"fileTreeElement");
                        if (fileTreeElement2.isDirectory()) {
                            bl = true;
                        } else {
                            Iterable $this$any$iv = this.$filesToInclude;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    String it = (String)element$iv;
                                    boolean bl2 = false;
                                    File file = fileTreeElement.getFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"fileTreeElement\n                        .file");
                                    String string = file.getAbsolutePath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileTreeElement\n        \u2026            .absolutePath");
                                    if (!StringsKt.endsWith$default((String)StringsKt.replace$default((String)string, (String)"\\", (String)"/", (boolean)false, (int)4, null), (String)it, (boolean)false, (int)2, null)) continue;
                                    bl = true;
                                    break block5;
                                }
                                bl = false;
                            }
                        }
                    }
                    return bl;
                }
                {
                    this.$filesToInclude = list;
                }
            });
        } else {
            $this$applyGitFilter.exclude("*");
        }
    }
}

