/*
 * Decompiled with CFR 0.152.
 */
package org.jlleitschuh.gradle.ktlint;

import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jlleitschuh.gradle.ktlint.ConfigurationsKt$createKtLintReporterConfiguration$;
import org.jlleitschuh.gradle.ktlint.KtlintExtension;
import org.jlleitschuh.gradle.ktlint.reporter.CustomReporter;
import org.jlleitschuh.gradle.shadow.net.swiftzer.semver.SemVer;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0000\u001a \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0000\u001a\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a \u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"KTLINT_BASELINE_REPORTER_CONFIGURATION_DESCRIPTION", "", "KTLINT_BASELINE_REPORTER_CONFIGURATION_NAME", "KTLINT_CONFIGURATION_DESCRIPTION", "KTLINT_CONFIGURATION_NAME", "KTLINT_REPORTER_CONFIGURATION_DESCRIPTION", "KTLINT_REPORTER_CONFIGURATION_NAME", "KTLINT_RULESET_CONFIGURATION_DESCRIPTION", "KTLINT_RULESET_CONFIGURATION_NAME", "createKtLintBaselineReporterConfiguration", "Lorg/gradle/api/artifacts/Configuration;", "target", "Lorg/gradle/api/Project;", "extension", "Lorg/jlleitschuh/gradle/ktlint/KtlintExtension;", "ktLintConfiguration", "createKtLintReporterConfiguration", "createKtlintConfiguration", "createKtlintRulesetConfiguration", "ensureConsistencyWith", "", "otherConfiguration", "ktlint-gradle"})
public final class ConfigurationsKt {
    @NotNull
    public static final String KTLINT_CONFIGURATION_NAME = "ktlint";
    @NotNull
    public static final String KTLINT_CONFIGURATION_DESCRIPTION = "Main ktlint-gradle configuration";
    @NotNull
    public static final String KTLINT_RULESET_CONFIGURATION_NAME = "ktlintRuleset";
    @NotNull
    public static final String KTLINT_RULESET_CONFIGURATION_DESCRIPTION = "All ktlint rulesets dependencies";
    @NotNull
    public static final String KTLINT_REPORTER_CONFIGURATION_NAME = "ktlintReporter";
    @NotNull
    public static final String KTLINT_REPORTER_CONFIGURATION_DESCRIPTION = "All ktlint custom reporters dependencies";
    @NotNull
    public static final String KTLINT_BASELINE_REPORTER_CONFIGURATION_NAME = "ktlintBaselineReporter";
    @NotNull
    public static final String KTLINT_BASELINE_REPORTER_CONFIGURATION_DESCRIPTION = "Provides KtLint baseline reporter required to generate baseline file";

    @NotNull
    public static final Configuration createKtlintConfiguration(@NotNull Project target, @NotNull KtlintExtension extension) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Object object = target.getConfigurations().maybeCreate(KTLINT_CONFIGURATION_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"target.configurations.ma\u2026TLINT_CONFIGURATION_NAME)");
        Object object2 = object;
        Configuration $this$apply = (Configuration)object2;
        boolean bl = false;
        if ($this$apply.getState() == Configuration.State.UNRESOLVED) {
            $this$apply.setDescription(KTLINT_CONFIGURATION_DESCRIPTION);
            $this$apply.setCanBeResolved(true);
            $this$apply.setCanBeConsumed(false);
            $this$apply.setVisible(false);
            $this$apply.attributes(new Action(target, extension){
                final /* synthetic */ Project $target$inlined;
                final /* synthetic */ KtlintExtension $extension$inlined;
                {
                    this.$target$inlined = project;
                    this.$extension$inlined = ktlintExtension;
                }

                public final void execute(@NotNull AttributeContainer $this$attributes) {
                    Intrinsics.checkNotNullParameter((Object)$this$attributes, (String)"$receiver");
                    $this$attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)this.$target$inlined.getObjects().named(Bundling.class, "external"));
                }
            });
            ListProperty listProperty = target.getObjects().listProperty(Dependency.class);
            Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"target.objects.listPrope\u2026y(Dependency::class.java)");
            ListProperty oldProp = listProperty;
            $this$apply.getDependencies().addAllLater((Provider)oldProp.value(extension.getVersion().map(new Transformer(target, extension){
                final /* synthetic */ Project $target$inlined;
                final /* synthetic */ KtlintExtension $extension$inlined;
                {
                    this.$target$inlined = project;
                    this.$extension$inlined = ktlintExtension;
                }

                public final List<Dependency> transform(@NotNull String it) {
                    List list;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (SemVer.Companion.parse(it).compareTo(new SemVer(1, 0, 0, null, null, 24, null)) < 0) {
                        this.$target$inlined.getLogger().info("Add dependency: ktlint version " + it);
                        list = CollectionsKt.listOf((Object)this.$target$inlined.getDependencies().create((Object)("com.pinterest:ktlint:" + it)));
                    } else {
                        this.$target$inlined.getLogger().info("Add dependencies: ktlint version " + it);
                        list = CollectionsKt.listOf((Object[])new Dependency[]{this.$target$inlined.getDependencies().create((Object)("com.pinterest.ktlint:ktlint-cli:" + it)), this.$target$inlined.getDependencies().create((Object)"io.github.oshai:kotlin-logging:5.1.0"), this.$target$inlined.getDependencies().create((Object)"io.github.detekt.sarif4k:sarif4k:0.5.0")});
                    }
                    return list;
                }
            })));
        }
        return (Configuration)object2;
    }

    @NotNull
    public static final Configuration createKtlintRulesetConfiguration(@NotNull Project target, @NotNull Configuration ktLintConfiguration, @NotNull KtlintExtension extension) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)ktLintConfiguration, (String)"ktLintConfiguration");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Object object = target.getConfigurations().maybeCreate(KTLINT_RULESET_CONFIGURATION_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"target\n    .configuratio\u2026LESET_CONFIGURATION_NAME)");
        Object object2 = object;
        Configuration $this$apply = (Configuration)object2;
        boolean bl = false;
        $this$apply.setDescription(KTLINT_RULESET_CONFIGURATION_DESCRIPTION);
        $this$apply.setCanBeResolved(true);
        $this$apply.setCanBeConsumed(false);
        $this$apply.setVisible(false);
        ConfigurationsKt.ensureConsistencyWith($this$apply, target, ktLintConfiguration);
        $this$apply.getDependencies().addLater(target.provider(new Callable(target, ktLintConfiguration, extension){
            final /* synthetic */ Project $target$inlined;
            final /* synthetic */ Configuration $ktLintConfiguration$inlined;
            final /* synthetic */ KtlintExtension $extension$inlined;
            {
                this.$target$inlined = project;
                this.$ktLintConfiguration$inlined = configuration;
                this.$extension$inlined = ktlintExtension;
            }

            public final Dependency call() {
                Object object = this.$extension$inlined.getVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.version.get()");
                String ktlintVersion = (String)object;
                return this.$target$inlined.getDependencies().create((Object)("com.pinterest.ktlint:ktlint-ruleset-standard:" + ktlintVersion));
            }
        }));
        return (Configuration)object2;
    }

    @NotNull
    public static final Configuration createKtLintReporterConfiguration(@NotNull Project target, @NotNull KtlintExtension extension, @NotNull Configuration ktLintConfiguration) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)ktLintConfiguration, (String)"ktLintConfiguration");
        Object object = target.getConfigurations().maybeCreate(KTLINT_REPORTER_CONFIGURATION_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"target\n    .configuratio\u2026ORTER_CONFIGURATION_NAME)");
        Object object2 = object;
        Configuration $this$apply = (Configuration)object2;
        boolean bl = false;
        $this$apply.setDescription(KTLINT_REPORTER_CONFIGURATION_DESCRIPTION);
        $this$apply.setCanBeResolved(true);
        $this$apply.setCanBeConsumed(false);
        $this$apply.setVisible(false);
        ConfigurationsKt.ensureConsistencyWith($this$apply, target, ktLintConfiguration);
        $this$apply.withDependencies(new Action($this$apply, target, ktLintConfiguration, extension){
            final /* synthetic */ Configuration $this_apply;
            final /* synthetic */ Project $target$inlined;
            final /* synthetic */ Configuration $ktLintConfiguration$inlined;
            final /* synthetic */ KtlintExtension $extension$inlined;
            {
                this.$this_apply = configuration;
                this.$target$inlined = project;
                this.$ktLintConfiguration$inlined = configuration2;
                this.$extension$inlined = ktlintExtension;
            }

            public final void execute(@NotNull DependencySet $this$withDependencies) {
                Intrinsics.checkNotNullParameter((Object)$this$withDependencies, (String)"$receiver");
                this.$this_apply.getDependencies().addAllLater(this.$target$inlined.provider(new Callable(this){
                    final /* synthetic */ createKtLintReporterConfiguration$$inlined$apply$lambda$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final List<Dependency> call() {
                        Object object = this.this$0.$extension$inlined.getVersion().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.version.get()");
                        return SemVer.Companion.parse((String)object).compareTo(new SemVer(1, 0, 0, null, null, 24, null)) >= 0 ? CollectionsKt.listOf((Object)this.this$0.$target$inlined.getDependencies().create((Object)"io.github.detekt.sarif4k:sarif4k:0.5.0")) : CollectionsKt.emptyList();
                    }
                }));
                Iterable $this$forEach$iv = (Iterable)this.$extension$inlined.getReporterExtension$ktlint_gradle().getCustomReporters();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    CustomReporter it = (CustomReporter)element$iv;
                    boolean bl = false;
                    this.$this_apply.getDependencies().addLater(this.$target$inlined.provider(new Callable(it, this){
                        final /* synthetic */ CustomReporter $it;
                        final /* synthetic */ createKtLintReporterConfiguration$$inlined$apply$lambda$1 this$0;
                        {
                            this.$it = customReporter;
                            this.this$0 = var2_2;
                        }

                        public final Dependency call() {
                            Object reporterDependency = this.$it.getDependency();
                            if (reporterDependency == null) {
                                boolean bl = false;
                                String string = "Reporter " + this.$it.getReporterId() + " dependency is not set!";
                                throw new IllegalArgumentException(string.toString());
                            }
                            return this.this$0.$target$inlined.getDependencies().create(reporterDependency);
                        }
                    }));
                }
            }
        });
        ListProperty listProperty = target.getObjects().listProperty(Dependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"target.objects.listPrope\u2026y(Dependency::class.java)");
        ListProperty oldProp = listProperty;
        $this$apply.getDependencies().addAllLater((Provider)oldProp.value(extension.getVersion().map(new Transformer(target, ktLintConfiguration, extension){
            final /* synthetic */ Project $target$inlined;
            final /* synthetic */ Configuration $ktLintConfiguration$inlined;
            final /* synthetic */ KtlintExtension $extension$inlined;
            {
                this.$target$inlined = project;
                this.$ktLintConfiguration$inlined = configuration;
                this.$extension$inlined = ktlintExtension;
            }

            public final List<Dependency> transform(@NotNull String version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                return SemVer.Companion.parse(version).compareTo(new SemVer(1, 0, 0, null, null, 24, null)) >= 0 ? CollectionsKt.listOf((Object)this.$target$inlined.getDependencies().create((Object)"io.github.oshai:kotlin-logging:5.1.0")) : CollectionsKt.emptyList();
            }
        })));
        return (Configuration)object2;
    }

    @NotNull
    public static final Configuration createKtLintBaselineReporterConfiguration(@NotNull Project target, @NotNull KtlintExtension extension, @NotNull Configuration ktLintConfiguration) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)ktLintConfiguration, (String)"ktLintConfiguration");
        Object object = target.getConfigurations().maybeCreate(KTLINT_BASELINE_REPORTER_CONFIGURATION_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"target\n    .configuratio\u2026ORTER_CONFIGURATION_NAME)");
        Object object2 = object;
        Configuration $this$apply = (Configuration)object2;
        boolean bl = false;
        $this$apply.setDescription(KTLINT_BASELINE_REPORTER_CONFIGURATION_DESCRIPTION);
        $this$apply.setCanBeResolved(true);
        $this$apply.setCanBeConsumed(false);
        $this$apply.setVisible(false);
        ConfigurationsKt.ensureConsistencyWith($this$apply, target, ktLintConfiguration);
        ListProperty listProperty = target.getObjects().listProperty(Dependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"target.objects.listPrope\u2026y(Dependency::class.java)");
        ListProperty oldProp = listProperty;
        $this$apply.getDependencies().addAllLater((Provider)oldProp.value(extension.getVersion().map(new Transformer(target, ktLintConfiguration, extension){
            final /* synthetic */ Project $target$inlined;
            final /* synthetic */ Configuration $ktLintConfiguration$inlined;
            final /* synthetic */ KtlintExtension $extension$inlined;
            {
                this.$target$inlined = project;
                this.$ktLintConfiguration$inlined = configuration;
                this.$extension$inlined = ktlintExtension;
            }

            public final List<Dependency> transform(@NotNull String version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Object object = this.$extension$inlined.getVersion().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.version.get()");
                String ktlintVersion = (String)object;
                SemVer ktlintSemver = SemVer.Companion.parse(ktlintVersion);
                return ktlintSemver.compareTo(new SemVer(1, 0, 0, null, null, 24, null)) >= 0 ? CollectionsKt.listOf((Object[])new Dependency[]{this.$target$inlined.getDependencies().create((Object)("com.pinterest.ktlint:ktlint-cli-reporter-baseline:" + version)), this.$target$inlined.getDependencies().create((Object)"io.github.oshai:kotlin-logging:5.1.0")}) : CollectionsKt.listOf((Object)this.$target$inlined.getDependencies().create((Object)("com.pinterest.ktlint:ktlint-reporter-baseline:" + version)));
            }
        })));
        return (Configuration)object2;
    }

    private static final void ensureConsistencyWith(Configuration $this$ensureConsistencyWith, Project target, Configuration otherConfiguration) {
        $this$ensureConsistencyWith.shouldResolveConsistentlyWith(otherConfiguration);
    }
}

