/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.dnssec.validator;

import org.jitsi.dnssec.SRRset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Name;

public final class KeyEntry {
    private static final Logger logger = LoggerFactory.getLogger(KeyEntry.class);
    private SRRset rrset;
    private Name name;
    private int dclass;
    private long ttl;
    private boolean isBad = false;
    private String badReason;

    private KeyEntry(SRRset rrset) {
        this.rrset = rrset;
        this.name = rrset.getName();
        this.dclass = rrset.getDClass();
        this.ttl = rrset.getTTL();
    }

    private KeyEntry(Name name, int dclass, long ttl, boolean isBad) {
        this.rrset = null;
        this.name = name;
        this.dclass = dclass;
        this.ttl = ttl;
        this.isBad = isBad;
    }

    public static KeyEntry newKeyEntry(SRRset rrset) {
        return new KeyEntry(rrset);
    }

    public static KeyEntry newNullKeyEntry(Name n, int dclass, long ttl) {
        return new KeyEntry(n, dclass, ttl, false);
    }

    public static KeyEntry newBadKeyEntry(Name n, int dclass, long ttl) {
        return new KeyEntry(n, dclass, ttl, true);
    }

    public SRRset getRRset() {
        return this.rrset;
    }

    public Name getName() {
        return this.name;
    }

    public int getDClass() {
        return this.dclass;
    }

    public long getTTL() {
        return this.ttl;
    }

    public boolean isNull() {
        return !this.isBad && this.rrset == null;
    }

    public boolean isBad() {
        return this.isBad;
    }

    public boolean isGood() {
        return !this.isBad && this.rrset != null;
    }

    public String getBadReason() {
        return this.badReason;
    }

    public void setBadReason(String reason) {
        this.badReason = reason;
        logger.debug(this.badReason);
    }
}

