/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.ui;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.ui.EDT;

public abstract class EdtInvocationManager {
    private static final AtomicReference<EdtInvocationManager> ourInstance = new AtomicReference();

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(0);
        }
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            EdtInvocationManager.getInstance().invokeLater(runnable);
        }
    }

    @Deprecated
    public final boolean isEventDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    public abstract void invokeLater(@NotNull Runnable var1);

    public abstract void invokeAndWait(@NotNull Runnable var1) throws InvocationTargetException, InterruptedException;

    @NotNull
    public static EdtInvocationManager getInstance() {
        EdtInvocationManager result2 = ourInstance.get();
        if (result2 == null && !ourInstance.compareAndSet(null, result2 = new SwingEdtInvocationManager())) {
            result2 = ourInstance.get();
        }
        EdtInvocationManager edtInvocationManager = result2;
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(1);
        }
        return edtInvocationManager;
    }

    @Nullable
    public static EdtInvocationManager setEdtInvocationManager(@NotNull EdtInvocationManager edtInvocationManager) {
        if (edtInvocationManager == null) {
            EdtInvocationManager.$$$reportNull$$$0(2);
        }
        return ourInstance.getAndSet(edtInvocationManager);
    }

    public static void invokeAndWaitIfNeeded(@NotNull Runnable runnable) {
        if (runnable == null) {
            EdtInvocationManager.$$$reportNull$$$0(3);
        }
        if (EDT.isCurrentThreadEdt()) {
            runnable.run();
        } else {
            try {
                EdtInvocationManager.getInstance().invokeAndWait(runnable);
            }
            catch (Exception e) {
                Logger.getInstance(EdtInvocationManager.class).error(e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edtInvocationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEdtInvocationManager";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeAndWaitIfNeeded";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SwingEdtInvocationManager
    extends EdtInvocationManager {
        @Override
        public void invokeLater(@NotNull Runnable task2) {
            if (task2 == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(0);
            }
            EventQueue.invokeLater(task2);
        }

        @Override
        public void invokeAndWait(@NotNull Runnable task2) throws InvocationTargetException, InterruptedException {
            if (task2 == null) {
                SwingEdtInvocationManager.$$$reportNull$$$0(1);
            }
            EventQueue.invokeAndWait(task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "task";
            objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ui/EdtInvocationManager$SwingEdtInvocationManager";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeLater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invokeAndWait";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

