/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.text;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public final class StringTokenizer
implements Enumeration<String> {
    private int currentPosition;
    private int newPosition;
    private int maxPosition;
    private String str;
    private String delimiters;
    private final boolean retDelims;
    private boolean delimsChanged;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        for (int i2 = 0; i2 < this.delimiters.length(); ++i2) {
            char c = this.delimiters.charAt(i2);
            if (m >= c) continue;
            m = c;
        }
        this.maxDelimChar = m;
    }

    public StringTokenizer(@NotNull String str, @NotNull String delim, boolean returnDelims) {
        if (str == null) {
            StringTokenizer.$$$reportNull$$$0(0);
        }
        if (delim == null) {
            StringTokenizer.$$$reportNull$$$0(1);
        }
        this.currentPosition = 0;
        this.newPosition = -1;
        this.delimsChanged = false;
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public StringTokenizer(@NotNull String str, @NotNull String delim) {
        if (str == null) {
            StringTokenizer.$$$reportNull$$$0(2);
        }
        if (delim == null) {
            StringTokenizer.$$$reportNull$$$0(3);
        }
        this(str, delim, false);
    }

    public StringTokenizer(@NotNull String str) {
        if (str == null) {
            StringTokenizer.$$$reportNull$$$0(4);
        }
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; !this.retDelims && position < this.maxPosition && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && ((c = this.str.charAt(position)) > this.maxDelimChar || this.delimiters.indexOf(c) < 0); ++position) {
        }
        if (this.retDelims && startPos == position && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    @NotNull
    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start2 = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        String string2 = this.str.substring(start2, this.currentPosition);
        if (string2 == null) {
            StringTokenizer.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @NotNull
    public String nextToken(@NotNull String delim) {
        if (delim == null) {
            StringTokenizer.$$$reportNull$$$0(6);
        }
        this.delimiters = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        String string2 = this.nextToken();
        if (string2 == null) {
            StringTokenizer.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    @NotNull
    public String nextElement() {
        String string2 = this.nextToken();
        if (string2 == null) {
            StringTokenizer.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) < this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public void reset(@NotNull String s) {
        if (s == null) {
            StringTokenizer.$$$reportNull$$$0(9);
        }
        this.str = s;
        this.currentPosition = 0;
        this.newPosition = -1;
        this.maxPosition = s.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delim";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/text/StringTokenizer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/text/StringTokenizer";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "nextToken";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "nextElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "nextToken";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

