/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.util;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.UserDataHolder;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.IntObjectMap;

@NonNls
public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private static final IntObjectMap<Key<?>> allKeys = ContainerUtil.createIntKeyWeakValueMap();
    private final int myIndex;
    private final String myName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key(@NonNls @NotNull String name2) {
        if (name2 == null) {
            Key.$$$reportNull$$$0(0);
        }
        this.myIndex = ourKeysCounter.getAndIncrement();
        this.myName = name2;
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            allKeys.put(this.myIndex, this);
        }
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj2) {
        return obj2 == this;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static <T> Key<T> create(@NonNls @NotNull String name2) {
        if (name2 == null) {
            Key.$$$reportNull$$$0(1);
        }
        return new Key<T>(name2);
    }

    @Contract(value="null -> null")
    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    @Contract(value="_, !null -> !null")
    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    @NotNull
    public T getRequired(@NotNull UserDataHolder holder) {
        if (holder == null) {
            Key.$$$reportNull$$$0(2);
        }
        Object t = Objects.requireNonNull(holder.getUserData(this));
        if (t == null) {
            Key.$$$reportNull$$$0(3);
        }
        return t;
    }

    public boolean isIn(@Nullable UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value2) {
        if (holder != null) {
            holder.putUserData(this, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="can become null if the key has been gc-ed")
    public static <T> @Nullable(value="can become null if the key has been gc-ed") Key<T> getKeyByIndex(int index) {
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            return allKeys.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public static Key<?> findKeyByName(@NotNull String name2) {
        if (name2 == null) {
            Key.$$$reportNull$$$0(4);
        }
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            for (Key<?> key : allKeys.values()) {
                if (!name2.equals(key.myName)) continue;
                return key;
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/util/Key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/util/Key";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequired";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequired";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findKeyByName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

