/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.metadata.AbstractFirMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.AbstractMetadataSerializer;
import org.jetbrains.kotlin.cli.metadata.K1LegacyMetadataSerializerKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.comparators.FirMemberDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.pipeline.ModuleCompilerAnalyzedOutput;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareSerializableStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtensionBase;
import org.jetbrains.kotlin.fir.serialization.TypeApproximatorForMetadataSerializer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.gradle.internal.config.CompilerConfiguration;
import org.jetbrains.kotlin.gradle.internal.config.LanguageVersionSettings;
import org.jetbrains.kotlin.gradle.internal.metadata.ProtoBuf;
import org.jetbrains.kotlin.gradle.internal.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.gradle.internal.metadata.jvm.JvmModuleProtoBuf;
import org.jetbrains.kotlin.gradle.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.gradle.internal.metadata.jvm.deserialization.ModuleMappingKt;
import org.jetbrains.kotlin.gradle.internal.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.gradle.internal.name.FqName;
import org.jetbrains.kotlin.gradle.internal.name.Name;
import org.jetbrains.kotlin.gradle.internal.serialization.SerializableStringTable;
import org.jetbrains.kotlin.gradle.internal.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.gradle.internal.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.gradle.internal.types.AbstractTypeApproximator;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\r\b\u0011\u0018\u00002\u00020\u0001:\u0003!\"#B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000e\u001a\u0004\u0018\u00010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ)\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\bH\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0016R\"\u0010\u0018\u001a\u00020\u00178\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u00020\u00178\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0019\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001d\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer;", "Lorg/jetbrains/kotlin/cli/metadata/AbstractFirMetadataSerializer;", "Lorg/jetbrains/kotlin/gradle/internal/config/CompilerConfiguration;", "configuration", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "environment", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "", "Lorg/jetbrains/kotlin/fir/pipeline/ModuleCompilerAnalyzedOutput;", "analysisResult", "Ljava/io/File;", "destDir", "Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer$OutputInfo;", "serialize", "(Ljava/util/List;Ljava/io/File;)Lorg/jetbrains/kotlin/cli/metadata/AbstractMetadataSerializer$OutputInfo;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "firFiles", "", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageContent;", "collectPackagesContent", "(Ljava/util/List;)Ljava/util/Map;", "", "totalSize", "I", "getTotalSize", "()I", "setTotalSize", "(I)V", "totalFiles", "getTotalFiles", "setTotalFiles", "PackageContent", "PackageSerializer", "FirLegacySerializerExtension", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nFirLegacyMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,208:1\n381#2,7:209\n381#2,7:216\n381#2,7:223\n*S KotlinDebug\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer\n*L\n73#1:209,7\n101#1:216,7\n105#1:223,7\n*E\n"})
public class FirLegacyMetadataSerializer
extends AbstractFirMetadataSerializer {
    private int totalSize;
    private int totalFiles;

    public FirLegacyMetadataSerializer(@NotNull CompilerConfiguration configuration2, @NotNull KotlinCoreEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        super(configuration2, environment2);
    }

    protected final int getTotalSize() {
        return this.totalSize;
    }

    protected final void setTotalSize(int n) {
        this.totalSize = n;
    }

    protected final int getTotalFiles() {
        return this.totalFiles;
    }

    protected final void setTotalFiles(int n) {
        this.totalFiles = n;
    }

    @Override
    @Nullable
    protected AbstractMetadataSerializer.OutputInfo serialize(@NotNull List<ModuleCompilerAnalyzedOutput> analysisResult, @NotNull File destDir) {
        JvmModuleProtoBuf.Module.Builder builder;
        Intrinsics.checkNotNullParameter(analysisResult, (String)"analysisResult");
        Intrinsics.checkNotNullParameter((Object)destDir, (String)"destDir");
        ModuleCompilerAnalyzedOutput moduleCompilerAnalyzedOutput = (ModuleCompilerAnalyzedOutput)CollectionsKt.single(analysisResult);
        FirSession session2 = moduleCompilerAnalyzedOutput.component1();
        ScopeSession scopeSession = moduleCompilerAnalyzedOutput.component2();
        List firFiles2 = moduleCompilerAnalyzedOutput.component3();
        Map<FqName, PackageContent> contentPerPackage = this.collectPackagesContent(firFiles2);
        Map packageTable = new LinkedHashMap();
        for (Map.Entry<FqName, PackageContent> entry2 : contentPerPackage.entrySet()) {
            FqName packageFqName = entry2.getKey();
            PackageContent content = entry2.getValue();
            List<FirRegularClass> classes = content.component1();
            Map<FirFile, List<FirMemberDeclaration>> membersPerFile = content.component2();
            for (FirRegularClass firRegularClass : classes) {
                File destFile = new File(destDir, K1LegacyMetadataSerializerKt.getClassFilePath(FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)((FirClassLikeDeclaration)firRegularClass))));
                new PackageSerializer(packageFqName, CollectionsKt.listOf((Object)firRegularClass), CollectionsKt.emptyList(), destFile, session2, scopeSession, (BinaryVersion)this.getMetadataVersion()).serialize();
            }
            for (Map.Entry entry3 : membersPerFile.entrySet()) {
                Object object;
                FirFile file2 = (FirFile)entry3.getKey();
                List members = (List)entry3.getValue();
                File destFile = new File(destDir, K1LegacyMetadataSerializerKt.getPackageFilePath(packageFqName, file2.getName()));
                new PackageSerializer(packageFqName, CollectionsKt.emptyList(), members, destFile, session2, scopeSession, (BinaryVersion)this.getMetadataVersion()).serialize();
                Map $this$getOrPut$iv = packageTable;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(packageFqName);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageParts answer$iv = new PackageParts(packageFqName.asString());
                    $this$getOrPut$iv.put(packageFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((PackageParts)object).addMetadataPart(FilesKt.getNameWithoutExtension((File)destFile));
            }
        }
        File kotlinModuleFile = new File(destDir, JvmCodegenUtil.getMappingFileName((String)JvmCodegenUtil.prepareModuleName((Name)FirModuleDataKt.getModuleData((FirSession)session2).getName())));
        JvmModuleProtoBuf.Module.Builder $this$serialize_u24lambda_u241 = builder = JvmModuleProtoBuf.Module.newBuilder();
        boolean bl = false;
        for (PackageParts packageParts : packageTable.values()) {
            Intrinsics.checkNotNull((Object)$this$serialize_u24lambda_u241);
            packageParts.addTo($this$serialize_u24lambda_u241);
        }
        JvmModuleProtoBuf.Module module2 = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"build(...)");
        byte[] packageTableBytes = ModuleMappingKt.serializeToByteArray((JvmModuleProtoBuf.Module)module2, (BinaryVersion)((BinaryVersion)JvmMetadataVersion.INSTANCE), (int)0);
        kotlinModuleFile.getParentFile().mkdirs();
        FilesKt.writeBytes((File)kotlinModuleFile, (byte[])packageTableBytes);
        return new AbstractMetadataSerializer.OutputInfo(this.totalSize, this.totalFiles);
    }

    @NotNull
    protected final Map<FqName, PackageContent> collectPackagesContent(@NotNull List<? extends FirFile> firFiles2) {
        Intrinsics.checkNotNullParameter(firFiles2, (String)"firFiles");
        Map contentPerPackage = new LinkedHashMap();
        for (FirFile firFile : firFiles2) {
            FqName packageFqName = UtilsKt.getPackageFqName((FirFile)firFile);
            for (FirDeclaration declaration : firFile.getDeclarations()) {
                Object object;
                Map $this$getOrPut$iv = contentPerPackage;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(packageFqName);
                if (value$iv == null) {
                    boolean bl = false;
                    PackageContent answer$iv = new PackageContent(null, null, 3, null);
                    $this$getOrPut$iv.put(packageFqName, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                PackageContent content = (PackageContent)object;
                FirDeclaration firDeclaration = declaration;
                if (firDeclaration instanceof FirCallableDeclaration || firDeclaration instanceof FirTypeAlias) {
                    List list;
                    Map<FirFile, List<FirMemberDeclaration>> $this$getOrPut$iv2 = content.getMembersPerFile();
                    boolean $i$f$getOrPut2 = false;
                    List value$iv2 = $this$getOrPut$iv2.get(firFile);
                    if (value$iv2 == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(firFile, answer$iv);
                        list = answer$iv;
                    } else {
                        list = value$iv2;
                    }
                    Collection collection = list;
                    collection.add(declaration);
                    continue;
                }
                if (firDeclaration instanceof FirRegularClass) {
                    ((Collection)content.getClasses()).add(declaration);
                    continue;
                }
                throw new IllegalStateException(("Unexpected declaration: " + UtilsKt.render((FirElement)((FirElement)declaration))).toString());
            }
        }
        return contentPerPackage;
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u00048\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u00068\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001a8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$FirLegacySerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtensionBase;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/gradle/internal/metadata/deserialization/BinaryVersion;", "metadataVersion", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "", "shouldUseTypeTable", "()Z", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Lorg/jetbrains/kotlin/gradle/internal/metadata/deserialization/BinaryVersion;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "getAdditionalMetadataProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "additionalMetadataProvider", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    public static final class FirLegacySerializerExtension
    extends FirSerializerExtensionBase {
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final BinaryVersion metadataVersion;

        public FirLegacySerializerExtension(@NotNull FirSession session2, @NotNull ScopeSession scopeSession, @NotNull BinaryVersion metadataVersion) {
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
            super((SerializerExtensionProtocol)BuiltInSerializerProtocol.INSTANCE);
            this.session = session2;
            this.scopeSession = scopeSession;
            this.metadataVersion = metadataVersion;
        }

        @NotNull
        public FirSession getSession() {
            return this.session;
        }

        @NotNull
        public ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @NotNull
        public BinaryVersion getMetadataVersion() {
            return this.metadataVersion;
        }

        @Nullable
        public ConstValueProvider getConstValueProvider() {
            return null;
        }

        @Nullable
        protected FirAdditionalMetadataProvider getAdditionalMetadataProvider() {
            return null;
        }

        public boolean shouldUseTypeTable() {
            return true;
        }
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0085\b\u0018\u00002\u00020\u0001B3\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ<\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001c\u0010\fR)\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001d\u001a\u0004\b\u001e\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageContent;", "", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "classes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "membersPerFile", "<init>", "(Ljava/util/List;Ljava/util/Map;)V", "component1", "()Ljava/util/List;", "component2", "()Ljava/util/Map;", "copy", "(Ljava/util/List;Ljava/util/Map;)Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageContent;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getClasses", "Ljava/util/Map;", "getMembersPerFile", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    protected static final class PackageContent {
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final Map<FirFile, List<FirMemberDeclaration>> membersPerFile;

        public PackageContent(@NotNull List<FirRegularClass> classes, @NotNull Map<FirFile, List<FirMemberDeclaration>> membersPerFile) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(membersPerFile, (String)"membersPerFile");
            this.classes = classes;
            this.membersPerFile = membersPerFile;
        }

        public /* synthetic */ PackageContent(List list, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                map2 = new LinkedHashMap();
            }
            this(list, map2);
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final Map<FirFile, List<FirMemberDeclaration>> getMembersPerFile() {
            return this.membersPerFile;
        }

        @NotNull
        public final List<FirRegularClass> component1() {
            return this.classes;
        }

        @NotNull
        public final Map<FirFile, List<FirMemberDeclaration>> component2() {
            return this.membersPerFile;
        }

        @NotNull
        public final PackageContent copy(@NotNull List<FirRegularClass> classes, @NotNull Map<FirFile, List<FirMemberDeclaration>> membersPerFile) {
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(membersPerFile, (String)"membersPerFile");
            return new PackageContent(classes, membersPerFile);
        }

        public static /* synthetic */ PackageContent copy$default(PackageContent packageContent, List list, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                list = packageContent.classes;
            }
            if ((n & 2) != 0) {
                map2 = packageContent.membersPerFile;
            }
            return packageContent.copy(list, map2);
        }

        @NotNull
        public String toString() {
            return "PackageContent(classes=" + this.classes + ", membersPerFile=" + this.membersPerFile + ')';
        }

        public int hashCode() {
            int result2 = ((Object)this.classes).hashCode();
            result2 = result2 * 31 + ((Object)this.membersPerFile).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageContent)) {
                return false;
            }
            PackageContent packageContent = (PackageContent)other;
            if (!Intrinsics.areEqual(this.classes, packageContent.classes)) {
                return false;
            }
            return Intrinsics.areEqual(this.membersPerFile, packageContent.membersPerFile);
        }

        public PackageContent() {
            this(null, null, 3, null);
        }
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0085\u0004\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u0018\u001a\u00020\u00132\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0015J\u000f\u0010\u001b\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0015J\u000f\u0010\u001c\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0015J\u0017\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010#R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010$\u001a\u0004\b%\u0010&R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00048\u0006\u00a2\u0006\f\n\u0004\b\b\u0010$\u001a\u0004\b'\u0010&R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010+\u001a\u0004\b,\u0010-R\u0017\u0010\u000e\u001a\u00020\r8\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010.\u001a\u0004\b/\u00100R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001c\u00106\u001a\n 5*\u0004\u0018\u000104048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0017\u00109\u001a\u0002088\u0006\u00a2\u0006\f\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<R\u0014\u0010=\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b=\u0010>\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageSerializer;", "", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "packageFqName", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "classes", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "members", "Ljava/io/File;", "destFile", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/gradle/internal/metadata/deserialization/BinaryVersion;", "metadataVersion", "<init>", "(Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer;Lorg/jetbrains/kotlin/name/FqName;Ljava/util/List;Ljava/util/List;Ljava/io/File;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;)V", "", "serialize", "()V", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "parentSerializer", "serializeClasses", "(Ljava/util/List;Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "serializeMembers", "serializeStringTable", "serializeBuiltInsFile", "Ljava/io/ByteArrayOutputStream;", "stream", "write", "(Ljava/io/ByteArrayOutputStream;)V", "Lorg/jetbrains/kotlin/gradle/internal/name/FqName;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "Ljava/util/List;", "getClasses", "()Ljava/util/List;", "getMembers", "Ljava/io/File;", "getDestFile", "()Ljava/io/File;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$FirLegacySerializerExtension;", "extension", "Lorg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$FirLegacySerializerExtension;", "Lorg/jetbrains/kotlin/gradle/internal/metadata/ProtoBuf$PackageFragment$Builder;", "kotlin.jvm.PlatformType", "proto", "Lorg/jetbrains/kotlin/gradle/internal/metadata/ProtoBuf$PackageFragment$Builder;", "Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "typeApproximator", "Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "getTypeApproximator", "()Lorg/jetbrains/kotlin/fir/serialization/TypeApproximatorForMetadataSerializer;", "rootSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    @SourceDebugExtension(value={"SMAP\nFirLegacyMetadataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageSerializer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,208:1\n1557#2:209\n1628#2,3:210\n13423#3,2:213\n1#4:215\n*S KotlinDebug\n*F\n+ 1 FirLegacyMetadataSerializer.kt\norg/jetbrains/kotlin/cli/metadata/FirLegacyMetadataSerializer$PackageSerializer\n*L\n150#1:209\n150#1:210,3\n181#1:213,2\n*E\n"})
    protected final class PackageSerializer {
        @NotNull
        private final FqName packageFqName;
        @NotNull
        private final List<FirRegularClass> classes;
        @NotNull
        private final List<FirMemberDeclaration> members;
        @NotNull
        private final File destFile;
        @NotNull
        private final FirSession session;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final FirLegacySerializerExtension extension;
        private final ProtoBuf.PackageFragment.Builder proto;
        @NotNull
        private final TypeApproximatorForMetadataSerializer typeApproximator;
        @NotNull
        private final FirElementSerializer rootSerializer;

        public PackageSerializer(@NotNull FqName packageFqName, @NotNull List<? extends FirRegularClass> classes, @NotNull List<? extends FirMemberDeclaration> members, @NotNull File destFile, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, BinaryVersion metadataVersion) {
            Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
            Intrinsics.checkNotNullParameter(classes, (String)"classes");
            Intrinsics.checkNotNullParameter(members, (String)"members");
            Intrinsics.checkNotNullParameter((Object)destFile, (String)"destFile");
            Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
            Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
            Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
            this.packageFqName = packageFqName;
            this.classes = classes;
            this.members = members;
            this.destFile = destFile;
            this.session = session2;
            this.scopeSession = scopeSession;
            this.extension = new FirLegacySerializerExtension(this.session, this.scopeSession, metadataVersion);
            this.proto = ProtoBuf.PackageFragment.newBuilder();
            this.typeApproximator = new TypeApproximatorForMetadataSerializer(this.session);
            this.rootSerializer = FirElementSerializer.Companion.createTopLevel$default((FirElementSerializer.Companion)FirElementSerializer.Companion, (FirSession)this.session, (ScopeSession)this.scopeSession, (FirSerializerExtension)((FirSerializerExtension)this.extension), (AbstractTypeApproximator)((AbstractTypeApproximator)this.typeApproximator), (LanguageVersionSettings)FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)this.session), (boolean)false, (int)32, null);
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @NotNull
        public final List<FirRegularClass> getClasses() {
            return this.classes;
        }

        @NotNull
        public final List<FirMemberDeclaration> getMembers() {
            return this.members;
        }

        @NotNull
        public final File getDestFile() {
            return this.destFile;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @NotNull
        public final ScopeSession getScopeSession() {
            return this.scopeSession;
        }

        @NotNull
        public final TypeApproximatorForMetadataSerializer getTypeApproximator() {
            return this.typeApproximator;
        }

        public final void serialize() {
            this.serializeClasses(this.classes, this.rootSerializer);
            this.serializeMembers();
            this.serializeStringTable();
            this.serializeBuiltInsFile();
        }

        /*
         * WARNING - void declaration
         */
        private final void serializeClasses(List<? extends FirRegularClass> classes, FirElementSerializer parentSerializer) {
            for (FirRegularClass klass : CollectionsKt.sortedWith((Iterable)classes, (Comparator)((Comparator)FirMemberDeclarationComparator.INSTANCE))) {
                void $this$mapTo$iv$iv;
                FirElementSerializer classSerializer = FirElementSerializer.Companion.create$default((FirElementSerializer.Companion)FirElementSerializer.Companion, (FirSession)this.session, (ScopeSession)this.scopeSession, (FirClass)((FirClass)klass), (FirSerializerExtension)((FirSerializerExtension)this.extension), (FirElementSerializer)parentSerializer, (AbstractTypeApproximator)((AbstractTypeApproximator)this.typeApproximator), (LanguageVersionSettings)FirLanguageSettingsComponentKt.getLanguageVersionSettings((FirSession)this.session), (boolean)false, (int)128, null);
                Iterable $this$map$iv = classSerializer.computeNestedClassifiersForClass((FirClassSymbol)klass.getSymbol());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirClassifierSymbol firClassifierSymbol = (FirClassifierSymbol)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    FirDeclaration firDeclaration = it.getFir();
                    Intrinsics.checkNotNull((Object)firDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
                    collection.add((FirRegularClass)firDeclaration);
                }
                List nestedClasses = (List)destination$iv$iv;
                if (!((Collection)nestedClasses).isEmpty()) {
                    this.serializeClasses(nestedClasses, classSerializer);
                }
                ProtoBuf.Class.Builder classProto = classSerializer.classProto((FirClass)klass);
                this.proto.addClass_(classProto.build());
            }
        }

        private final void serializeMembers() {
            ProtoBuf.Package.Builder packagePartProto = this.rootSerializer.packagePartProto(this.packageFqName, CollectionsKt.sortedWith((Iterable)this.members, (Comparator)((Comparator)FirMemberDeclarationComparator.INSTANCE)), null);
            this.proto.setPackage(packagePartProto.build());
        }

        private final void serializeStringTable() {
            FirElementAwareSerializableStringTable firElementAwareSerializableStringTable = this.extension.getStringTable();
            SerializableStringTable serializableStringTable = firElementAwareSerializableStringTable instanceof SerializableStringTable ? (SerializableStringTable)firElementAwareSerializableStringTable : null;
            if (serializableStringTable == null || (serializableStringTable = serializableStringTable.buildProto()) == null) {
                return;
            }
            SerializableStringTable serializableStringTable2 = serializableStringTable;
            ProtoBuf.StringTable strings2 = (ProtoBuf.StringTable)serializableStringTable2.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)serializableStringTable2.component2();
            this.proto.setStrings(strings2);
            this.proto.setQualifiedNames(qualifiedNames);
        }

        private final void serializeBuiltInsFile() {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            DataOutputStream $this$serializeBuiltInsFile_u24lambda_u242 = new DataOutputStream(stream);
            boolean bl = false;
            int[] version2 = this.extension.getMetadataVersion().toArray();
            $this$serializeBuiltInsFile_u24lambda_u242.writeInt(version2.length);
            int[] $this$forEach$iv = version2;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                int element$iv;
                int it = element$iv = $this$forEach$iv[j];
                boolean bl2 = false;
                $this$serializeBuiltInsFile_u24lambda_u242.writeInt(it);
            }
            this.proto.build().writeTo((OutputStream)stream);
            this.write(stream);
        }

        private final void write(ByteArrayOutputStream stream) {
            FirLegacyMetadataSerializer.this.setTotalSize(FirLegacyMetadataSerializer.this.getTotalSize() + stream.size());
            int n = FirLegacyMetadataSerializer.this.getTotalFiles();
            FirLegacyMetadataSerializer.this.setTotalFiles(n + 1);
            int n2 = n = !this.destFile.isDirectory() ? 1 : 0;
            if (_Assertions.ENABLED && n == 0) {
                boolean bl = false;
                String string2 = "Cannot write because output destination is a directory: " + this.destFile;
                throw new AssertionError((Object)string2);
            }
            this.destFile.getParentFile().mkdirs();
            byte[] byArray = stream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            FilesKt.writeBytes((File)this.destFile, (byte[])byArray);
        }
    }
}

