/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplCodeLine;
import org.jetbrains.kotlin.com.google.common.base.Throwables;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.LineSeparator;
import org.jetbrains.kotlin.gradle.internal.utils.repl.ReplEscapeType;

@Metadata(k=2, mv={2, 0, 0}, d1={"\u0000L\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\u001a\u0016\u0010\u0002\u001a\u00070\u0000\u00a2\u0006\u0002\b\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0016\u0010\u0004\u001a\u00070\u0000\u00a2\u0006\u0002\b\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u0019\u0010\u0007\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0011\u0010\t\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\t\u0010\u0003\u001a\u0011\u0010\n\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\n\u0010\u0003\u001a\u0011\u0010\u000b\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\u0003\u001a\u0011\u0010\f\u001a\u00020\u0000*\u00020\u0000\u00a2\u0006\u0004\b\f\u0010\u0003\u001a\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0015\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u001d\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0019\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001aH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u0019\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b*\u00020\u001fH\u0000\u00a2\u0006\u0004\b \u0010!\u001a1\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b\"\b\b\u0000\u0010#*\u00020\"*\b\u0012\u0004\u0012\u00028\u00000\u001b2\u0006\u0010$\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b%\u0010&\"\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00000\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\"\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00000\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010(\"\u0014\u0010*\u001a\u00020\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\"\u0014\u0010,\u001a\u00020\u00008\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b,\u0010+\u00a8\u0006-"}, d2={"", "Lorg/jetbrains/annotations/NotNull;", "replUnescapeLineBreaks", "(Ljava/lang/String;)Ljava/lang/String;", "replEscapeLineBreaks", "Lorg/jetbrains/kotlin/gradle/internal/utils/repl/ReplEscapeType;", "escapeType", "replOutputAsXml", "(Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/internal/utils/repl/ReplEscapeType;)Ljava/lang/String;", "replInputAsXml", "replAddLineBreak", "replRemoveLineBreaksInTheEnd", "replNormalizeLineBreaks", "Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;", "codeLine", "makeScriptBaseName", "(Lorg/jetbrains/kotlin/cli/common/repl/ReplCodeLine;)Ljava/lang/String;", "", "lineNo", "scriptResultFieldName", "(I)Ljava/lang/String;", "", "cause", "startFromMethodName", "renderReplStackTrace", "(Ljava/lang/Throwable;Ljava/lang/String;)Ljava/lang/String;", "Ljava/lang/ClassLoader;", "", "Ljava/io/File;", "listAllUrlsAsFiles", "(Ljava/lang/ClassLoader;)Ljava/util/List;", "Ljava/net/URLClassLoader;", "listLocalUrlsAsFiles", "(Ljava/net/URLClassLoader;)Ljava/util/List;", "", "T", "error", "ensureNotEmpty", "(Ljava/util/List;Ljava/lang/String;)Ljava/util/List;", "SOURCE_CHARS", "Ljava/util/List;", "XML_REPLACEMENTS", "END_LINE", "Ljava/lang/String;", "XML_PREAMBLE", "cli-common"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
@SourceDebugExtension(value={"SMAP\nreplUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 replUtil.kt\norg/jetbrains/kotlin/cli/common/repl/ReplUtilKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n37#2:91\n36#2,3:92\n1288#3,3:95\n11476#4,9:98\n13402#4:107\n13403#4:109\n11485#4:110\n1#5:108\n1557#6:111\n1628#6,3:112\n*S KotlinDebug\n*F\n+ 1 replUtil.kt\norg/jetbrains/kotlin/cli/common/repl/ReplUtilKt\n*L\n70#1:91\n70#1:92,3\n77#1:95,3\n83#1:98,9\n83#1:107\n83#1:109\n83#1:110\n83#1:108\n83#1:111\n83#1:112,3\n*E\n"})
public final class ReplUtilKt {
    @NotNull
    private static final List<String> SOURCE_CHARS;
    @NotNull
    private static final List<String> XML_REPLACEMENTS;
    @NotNull
    private static final String END_LINE;
    @NotNull
    private static final String XML_PREAMBLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

    @NotNull
    public static final String replUnescapeLineBreaks(@NotNull String $this$replUnescapeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$replUnescapeLineBreaks, (String)"<this>");
        String string2 = StringUtil.replace($this$replUnescapeLineBreaks, XML_REPLACEMENTS, SOURCE_CHARS);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replace(...)");
        return string2;
    }

    @NotNull
    public static final String replEscapeLineBreaks(@NotNull String $this$replEscapeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$replEscapeLineBreaks, (String)"<this>");
        String string2 = StringUtil.replace($this$replEscapeLineBreaks, SOURCE_CHARS, XML_REPLACEMENTS);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replace(...)");
        return string2;
    }

    @NotNull
    public static final String replOutputAsXml(@NotNull String $this$replOutputAsXml, @NotNull ReplEscapeType escapeType) {
        Intrinsics.checkNotNullParameter((Object)$this$replOutputAsXml, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)escapeType), (String)"escapeType");
        String string2 = StringUtil.escapeXmlEntities(ReplUtilKt.replEscapeLineBreaks($this$replOutputAsXml));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
        String escapedXml = string2;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><output type=\"" + (Object)((Object)escapeType) + "\">" + escapedXml + "</output>";
    }

    @NotNull
    public static final String replInputAsXml(@NotNull String $this$replInputAsXml) {
        Intrinsics.checkNotNullParameter((Object)$this$replInputAsXml, (String)"<this>");
        String string2 = StringUtil.escapeXmlEntities(ReplUtilKt.replEscapeLineBreaks($this$replInputAsXml));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeXmlEntities(...)");
        String escapedXml = string2;
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><input>" + escapedXml + "</input>";
    }

    @NotNull
    public static final String replAddLineBreak(@NotNull String $this$replAddLineBreak) {
        Intrinsics.checkNotNullParameter((Object)$this$replAddLineBreak, (String)"<this>");
        return $this$replAddLineBreak + END_LINE;
    }

    @NotNull
    public static final String replRemoveLineBreaksInTheEnd(@NotNull String $this$replRemoveLineBreaksInTheEnd) {
        Intrinsics.checkNotNullParameter((Object)$this$replRemoveLineBreaksInTheEnd, (String)"<this>");
        char[] cArray = END_LINE.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] cArray2 = cArray;
        return StringsKt.trimEnd((String)$this$replRemoveLineBreaksInTheEnd, (char[])Arrays.copyOf(cArray2, cArray2.length));
    }

    @NotNull
    public static final String replNormalizeLineBreaks(@NotNull String $this$replNormalizeLineBreaks) {
        Intrinsics.checkNotNullParameter((Object)$this$replNormalizeLineBreaks, (String)"<this>");
        return StringsKt.replace$default((String)$this$replNormalizeLineBreaks, (String)END_LINE, (String)"\n", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String makeScriptBaseName(@NotNull ReplCodeLine codeLine) {
        Intrinsics.checkNotNullParameter((Object)codeLine, (String)"codeLine");
        return "Line_" + codeLine.getNo() + (codeLine.getGeneration() > 1 ? "_gen_" + codeLine.getGeneration() : "");
    }

    @NotNull
    public static final String scriptResultFieldName(int lineNo) {
        return "res" + lineNo;
    }

    @NotNull
    public static final String renderReplStackTrace(@NotNull Throwable cause2, @NotNull String startFromMethodName) {
        Intrinsics.checkNotNullParameter((Object)cause2, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)startFromMethodName, (String)"startFromMethodName");
        ArrayList<StackTraceElement> newTrace = new ArrayList<StackTraceElement>();
        boolean skip = true;
        StackTraceElement[] stackTraceElementArray = cause2.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        List list = ArraysKt.reversed((Object[])stackTraceElementArray);
        int n = list.size();
        for (int j = 0; j < n; ++j) {
            StackTraceElement element = (StackTraceElement)list.get(j);
            if (Intrinsics.areEqual((Object)(element.getClassName() + '.' + element.getMethodName()), (Object)startFromMethodName)) {
                skip = false;
            }
            if (skip) continue;
            newTrace.add(element);
        }
        List resultingTrace = CollectionsKt.dropLast((List)CollectionsKt.reversed((Iterable)newTrace), (int)1);
        Collection $this$toTypedArray$iv = resultingTrace;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        cause2.setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
        String string2 = Throwables.getStackTraceAsString(cause2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStackTraceAsString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listAllUrlsAsFiles(@NotNull ClassLoader $this$listAllUrlsAsFiles) {
        void $this$fold$iv;
        Sequence parents;
        Intrinsics.checkNotNullParameter((Object)$this$listAllUrlsAsFiles, (String)"<this>");
        Sequence sequence = parents = SequencesKt.filterIsInstance((Sequence)SequencesKt.generateSequence((Object)$this$listAllUrlsAsFiles, ReplUtilKt::listAllUrlsAsFiles$lambda$0), URLClassLoader.class);
        List initial$iv = CollectionsKt.emptyList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void loader;
            URLClassLoader uRLClassLoader = (URLClassLoader)element$iv;
            List accum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = CollectionsKt.plus((Collection)ReplUtilKt.listLocalUrlsAsFiles((URLClassLoader)loader), (Iterable)accum);
        }
        return CollectionsKt.distinct((Iterable)accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> listLocalUrlsAsFiles(@NotNull URLClassLoader $this$listLocalUrlsAsFiles) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$listLocalUrlsAsFiles, (String)"<this>");
        URL[] uRLArray = $this$listLocalUrlsAsFiles.getURLs();
        Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
        Object[] $this$mapNotNull$iv = uRLArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            String it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[j];
            boolean bl = false;
            URL it = (URL)element$iv$iv;
            boolean bl2 = false;
            String string2 = it.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            if (StringsKt.removePrefix((String)string2, (CharSequence)"file:") == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)p0));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T> List<T> ensureNotEmpty(@NotNull List<? extends T> $this$ensureNotEmpty, @NotNull String error) {
        Intrinsics.checkNotNullParameter($this$ensureNotEmpty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if ($this$ensureNotEmpty.isEmpty()) {
            throw new IllegalStateException(error);
        }
        return $this$ensureNotEmpty;
    }

    private static final ClassLoader listAllUrlsAsFiles$lambda$0(ClassLoader loader) {
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        return loader.getParent();
    }

    static {
        Object[] objectArray = new String[]{"\r", "\n", "#"};
        SOURCE_CHARS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"#r", "#n", "#diez"};
        XML_REPLACEMENTS = CollectionsKt.listOf((Object[])objectArray);
        String string2 = LineSeparator.getSystemLineSeparator().getSeparatorString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparatorString(...)");
        END_LINE = string2;
    }
}

