/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.targets.native.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.commonizer.AdditionalCommonizerSetting;
import org.jetbrains.kotlin.commonizer.CommonizerLogLevel;
import org.jetbrains.kotlin.commonizer.CommonizerOutputFileLayout;
import org.jetbrains.kotlin.commonizer.CommonizerTarget;
import org.jetbrains.kotlin.commonizer.CommonizerTargetKt;
import org.jetbrains.kotlin.commonizer.KonanDistribution;
import org.jetbrains.kotlin.commonizer.KonanDistributionKt;
import org.jetbrains.kotlin.commonizer.LeafCommonizerTarget;
import org.jetbrains.kotlin.commonizer.NativeDistributionCommonizer;
import org.jetbrains.kotlin.commonizer.SharedCommonizerTarget;
import org.jetbrains.kotlin.gradle.targets.native.internal.NativeDistributionCommonizationCache;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002*\u0001\t\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0007J@\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0002J\u001e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0011H\u0002J$\u0010\u001d\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002J,\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache;", "Lorg/jetbrains/kotlin/commonizer/NativeDistributionCommonizer;", "logger", "Lorg/gradle/api/logging/Logger;", "isCachingEnabled", "", "commonizer", "(Lorg/gradle/api/logging/Logger;ZLorg/jetbrains/kotlin/commonizer/NativeDistributionCommonizer;)V", "lock", "org/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache$lock$1", "Lorg/jetbrains/kotlin/gradle/targets/native/internal/NativeDistributionCommonizationCache$lock$1;", "commonizeNativeDistribution", "", "konanHome", "Ljava/io/File;", "outputDirectory", "outputTargets", "", "Lorg/jetbrains/kotlin/commonizer/SharedCommonizerTarget;", "logLevel", "Lorg/jetbrains/kotlin/commonizer/CommonizerLogLevel;", "additionalSettings", "", "Lorg/jetbrains/kotlin/commonizer/AdditionalCommonizerSetting;", "isCached", "directory", "isMissingPlatformLibraries", "missingOutputTargets", "Lorg/jetbrains/kotlin/commonizer/CommonizerTarget;", "isUpToDate", "logInfo", "message", "", "todoTargets", "kotlin-gradle-plugin_common"})
public final class NativeDistributionCommonizationCache
implements NativeDistributionCommonizer {
    @NotNull
    private final Logger logger;
    private final boolean isCachingEnabled;
    @NotNull
    private final NativeDistributionCommonizer commonizer;
    @NotNull
    private final lock.1 lock;

    public NativeDistributionCommonizationCache(@NotNull Logger logger, boolean isCachingEnabled, @NotNull NativeDistributionCommonizer commonizer2) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)commonizer2, (String)"commonizer");
        this.logger = logger;
        this.isCachingEnabled = isCachingEnabled;
        this.commonizer = commonizer2;
        this.lock = new Object(this){
            @NotNull
            private final ReentrantLock reentrantLock;
            @NotNull
            private final Set<File> lockedOutputDirectories;
            final /* synthetic */ NativeDistributionCommonizationCache this$0;
            {
                this.this$0 = $receiver;
                this.reentrantLock = new ReentrantLock();
                this.lockedOutputDirectories = new LinkedHashSet<E>();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final <T> T withLock(@NotNull File outputDirectory2, @NotNull Function0<? extends T> action) {
                Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
                Intrinsics.checkNotNullParameter(action, (String)"action");
                Lock lock2 = this.reentrantLock;
                NativeDistributionCommonizationCache nativeDistributionCommonizationCache = this.this$0;
                lock2.lock();
                try {
                    Object object;
                    boolean bl = false;
                    if (this.lockedOutputDirectories.contains(outputDirectory2)) {
                        Object object2 = action.invoke();
                        return (T)object2;
                    }
                    outputDirectory2.mkdirs();
                    File lockfile = FilesKt.resolve((File)outputDirectory2, (String)".lock");
                    NativeDistributionCommonizationCache.access$logInfo(nativeDistributionCommonizationCache, "Acquire lock: " + lockfile.getPath() + " ...");
                    Closeable closeable = new FileOutputStream(FilesKt.resolve((File)outputDirectory2, (String)".lock"));
                    Throwable throwable = null;
                    try {
                        Object object3;
                        FileOutputStream stream = (FileOutputStream)closeable;
                        boolean bl2 = false;
                        FileLock lock3 = stream.getChannel().lock();
                        boolean bl3 = lock3.isValid();
                        if (_Assertions.ENABLED && !bl3) {
                            String string = "Assertion failed";
                            throw new AssertionError((Object)string);
                        }
                        try {
                            NativeDistributionCommonizationCache.access$logInfo(nativeDistributionCommonizationCache, "Lock acquired: " + lockfile.getPath());
                            this.lockedOutputDirectories.add(outputDirectory2);
                            object3 = action.invoke();
                        }
                        finally {
                            this.lockedOutputDirectories.remove(outputDirectory2);
                            lock3.release();
                            NativeDistributionCommonizationCache.access$logInfo(nativeDistributionCommonizationCache, "Lock released: " + lockfile.getPath());
                        }
                        object = object3;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            CloseableKt.closeFinally((Closeable)closeable, throwable);
                            throw throwable3;
                        }
                    }
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    Object object4 = object;
                    return (T)object4;
                }
                finally {
                    lock2.unlock();
                }
            }

            public final void checkLocked(@NotNull File outputDirectory2) {
                Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
                if (!this.reentrantLock.isHeldByCurrentThread()) {
                    boolean $i$a$-check-NativeDistributionCommonizationCache$lock$1$checkLocked$32 = false;
                    String $i$a$-check-NativeDistributionCommonizationCache$lock$1$checkLocked$32 = "Expected lock to be held by current thread " + Thread.currentThread().getName();
                    throw new IllegalStateException($i$a$-check-NativeDistributionCommonizationCache$lock$1$checkLocked$32.toString());
                }
                if (!this.lockedOutputDirectories.contains(outputDirectory2)) {
                    boolean bl = false;
                    String string = "Expected " + outputDirectory2 + " to be locked. Locked directories: " + this.lockedOutputDirectories;
                    throw new IllegalStateException(string.toString());
                }
            }
        };
    }

    public final boolean isUpToDate(@NotNull File konanHome2, @NotNull File outputDirectory2, @NotNull Set<SharedCommonizerTarget> outputTargets) {
        Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        return ((Set)this.lock.withLock(outputDirectory2, (Function0)new Function0<Set<? extends SharedCommonizerTarget>>(this, konanHome2, outputDirectory2, outputTargets){
            final /* synthetic */ NativeDistributionCommonizationCache this$0;
            final /* synthetic */ File $konanHome;
            final /* synthetic */ File $outputDirectory;
            final /* synthetic */ Set<SharedCommonizerTarget> $outputTargets;
            {
                this.this$0 = $receiver;
                this.$konanHome = $konanHome;
                this.$outputDirectory = $outputDirectory;
                this.$outputTargets = $outputTargets;
                super(0);
            }

            @NotNull
            public final Set<SharedCommonizerTarget> invoke() {
                return NativeDistributionCommonizationCache.access$todoTargets(this.this$0, this.$konanHome, this.$outputDirectory, this.$outputTargets);
            }
        })).isEmpty();
    }

    public void commonizeNativeDistribution(@NotNull File konanHome2, @NotNull File outputDirectory2, @NotNull Set<SharedCommonizerTarget> outputTargets, @NotNull CommonizerLogLevel logLevel, @NotNull List<? extends AdditionalCommonizerSetting<?>> additionalSettings) {
        Intrinsics.checkNotNullParameter((Object)konanHome2, (String)"konanHome");
        Intrinsics.checkNotNullParameter((Object)outputDirectory2, (String)"outputDirectory");
        Intrinsics.checkNotNullParameter(outputTargets, (String)"outputTargets");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter(additionalSettings, (String)"additionalSettings");
        this.lock.withLock(outputDirectory2, (Function0)new Function0<Unit>(this, konanHome2, outputDirectory2, outputTargets, logLevel, additionalSettings){
            final /* synthetic */ NativeDistributionCommonizationCache this$0;
            final /* synthetic */ File $konanHome;
            final /* synthetic */ File $outputDirectory;
            final /* synthetic */ Set<SharedCommonizerTarget> $outputTargets;
            final /* synthetic */ CommonizerLogLevel $logLevel;
            final /* synthetic */ List<AdditionalCommonizerSetting<?>> $additionalSettings;
            {
                this.this$0 = $receiver;
                this.$konanHome = $konanHome;
                this.$outputDirectory = $outputDirectory;
                this.$outputTargets = $outputTargets;
                this.$logLevel = $logLevel;
                this.$additionalSettings = $additionalSettings;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$filterTo$iv$iv;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Set todoOutputTargets = NativeDistributionCommonizationCache.access$todoTargets(this.this$0, this.$konanHome, this.$outputDirectory, this.$outputTargets);
                if (todoOutputTargets.isEmpty()) {
                    return;
                }
                NativeDistributionCommonizationCache.access$getCommonizer$p(this.this$0).commonizeNativeDistribution(this.$konanHome, this.$outputDirectory, todoOutputTargets, this.$logLevel, this.$additionalSettings);
                Iterable iterable = todoOutputTargets;
                File file = this.$outputDirectory;
                boolean $i$f$map22 = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void outputTarget;
                    SharedCommonizerTarget sharedCommonizerTarget = (SharedCommonizerTarget)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(file, (CommonizerTarget)outputTarget));
                }
                Iterable $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                Iterable $i$f$map22 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    File commonizedDirectory = (File)element$iv$iv;
                    boolean bl = false;
                    if (!commonizedDirectory.isDirectory()) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv2;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    File commonizedDirectory = (File)element$iv;
                    boolean bl = false;
                    FilesKt.resolve((File)commonizedDirectory, (String)".success").createNewFile();
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Set<SharedCommonizerTarget> todoTargets(File konanHome2, File outputDirectory2, Set<SharedCommonizerTarget> outputTargets) {
        void $this$onEach$iv;
        SharedCommonizerTarget outputTarget;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        this.lock.checkLocked(outputDirectory2);
        this.logInfo("Calculating cache state for " + outputTargets);
        if (!this.isCachingEnabled) {
            this.logInfo("Cache disabled");
            if (this.isMissingPlatformLibraries(konanHome2, outputTargets)) {
                return SetsKt.emptySet();
            }
            return outputTargets;
        }
        Iterable iterable = outputTargets;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            outputTarget = (SharedCommonizerTarget)element$iv$iv;
            boolean bl = false;
            if (!this.isCached(CommonizerOutputFileLayout.INSTANCE.resolveCommonizedDirectory(outputDirectory2, (CommonizerTarget)outputTarget))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2416$iv = var7_6 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2416$iv) {
            outputTarget = (SharedCommonizerTarget)element$iv;
            boolean bl2 = false;
            this.logInfo("Cache hit: " + outputTarget + " already commonized");
        }
        Set cachedOutputTargets = CollectionsKt.toSet((Iterable)var7_6);
        Set todoOutputTargets = SetsKt.minus(outputTargets, (Iterable)cachedOutputTargets);
        if (todoOutputTargets.isEmpty() || this.isMissingPlatformLibraries(konanHome2, todoOutputTargets)) {
            this.logInfo("All available targets are commonized already - Nothing to do");
            if (!((Collection)todoOutputTargets).isEmpty()) {
                this.logInfo("Platforms cannot be commonized, because of missing platform libraries: " + todoOutputTargets);
            }
            return SetsKt.emptySet();
        }
        return todoOutputTargets;
    }

    private final boolean isCached(File directory2) {
        File successMarkerFile = FilesKt.resolve((File)directory2, (String)".success");
        return successMarkerFile.isFile();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMissingPlatformLibraries(File konanHome2, Set<? extends CommonizerTarget> missingOutputTargets) {
        boolean bl;
        block5: {
            KonanTarget target2;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = CommonizerTargetKt.allLeaves((Iterable)missingOutputTargets);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                LeafCommonizerTarget leafCommonizerTarget = (LeafCommonizerTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(target2.getKonanTarget());
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void konanTarget2;
                target2 = (KonanTarget)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(FilesKt.resolve((File)KonanDistributionKt.getPlatformLibsDir((KonanDistribution)new KonanDistribution(konanHome2)), (String)konanTarget2.getName()));
            }
            Iterable $this$none$iv = (List)destination$iv$iv;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    File platformLibsDir = (File)element$iv;
                    boolean bl4 = false;
                    if (!platformLibsDir.exists()) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void logInfo(String message2) {
        this.logger.info("Native Distribution Commonization: " + message2);
    }

    public static final /* synthetic */ Set access$todoTargets(NativeDistributionCommonizationCache $this, File konanHome2, File outputDirectory2, Set outputTargets) {
        return $this.todoTargets(konanHome2, outputDirectory2, outputTargets);
    }

    public static final /* synthetic */ NativeDistributionCommonizer access$getCommonizer$p(NativeDistributionCommonizationCache $this) {
        return $this.commonizer;
    }

    public static final /* synthetic */ void access$logInfo(NativeDistributionCommonizationCache $this, String message2) {
        $this.logInfo(message2);
    }
}

