/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.AndroidSourceDirectorySet;
import com.android.build.gradle.api.AndroidSourceSet;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.ExtensionAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.internal.Kapt3GradleSubplugin;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinSourceSet;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.plugin.sources.KotlinSourceSetFactory;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0000\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0000\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0000\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0000\u001a\u00020\tH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"kotlinSourceSet", "Lorg/gradle/api/file/SourceDirectorySet;", "Lcom/android/build/gradle/api/AndroidSourceSet;", "getKotlinSourceSet", "(Lcom/android/build/gradle/api/AndroidSourceSet;)Lorg/gradle/api/file/SourceDirectorySet;", "createDefaultDependsOnEdges", "", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "Lorg/jetbrains/kotlin/gradle/plugin/KotlinSourceSet;", "androidSourceSet", "syncKotlinAndAndroidResources", "syncKotlinAndAndroidSourceDirs", "syncKotlinAndAndroidSourceSets", "addKotlinSources", "kotlin-gradle-plugin_common"})
public final class SyncKotlinAndAndroidSourceSetsKt {
    public static final void syncKotlinAndAndroidSourceSets(@NotNull KotlinAndroidTarget target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Project project = target2.getProject();
        Object object = project.getExtensions().getByName("android");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
        BaseExtension android2 = (BaseExtension)object;
        android2.getSourceSets().all(new Action(target2, project){
            final /* synthetic */ KotlinAndroidTarget $target;
            final /* synthetic */ Project $project;
            {
                this.$target = $target;
                this.$project = $project;
            }

            public final void execute(AndroidSourceSet androidSourceSet) {
                String string = androidSourceSet.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidSourceSet.name");
                String kotlinSourceSetName = AbstractAndroidProjectHandler.Companion.kotlinSourceSetNameForAndroidSourceSet(this.$target, string);
                KotlinSourceSet kotlinSourceSet = (KotlinSourceSet)KotlinProjectExtensionKt.getKotlinExtension(this.$project).getSourceSets().maybeCreate(kotlinSourceSetName);
                Intrinsics.checkNotNullExpressionValue((Object)androidSourceSet, (String)"androidSourceSet");
                Intrinsics.checkNotNullExpressionValue((Object)kotlinSourceSet, (String)"kotlinSourceSet");
                SyncKotlinAndAndroidSourceSetsKt.addKotlinSources(androidSourceSet, kotlinSourceSet);
                SyncKotlinAndAndroidSourceSetsKt.access$createDefaultDependsOnEdges(this.$target, kotlinSourceSet, androidSourceSet);
                SyncKotlinAndAndroidSourceSetsKt.access$syncKotlinAndAndroidSourceDirs(this.$target, kotlinSourceSet, androidSourceSet);
                SyncKotlinAndAndroidSourceSetsKt.access$syncKotlinAndAndroidResources(this.$target, kotlinSourceSet, androidSourceSet);
                KotlinPluginKt.ifKaptEnabled(this.$project, (Function0<Unit>)((Function0)new Function0<Unit>(this.$project, androidSourceSet){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ AndroidSourceSet $androidSourceSet;
                    {
                        this.$project = $project;
                        this.$androidSourceSet = $androidSourceSet;
                        super(0);
                    }

                    public final void invoke() {
                        String string = this.$androidSourceSet.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidSourceSet.name");
                        Kapt3GradleSubplugin.Companion.createAptConfigurationIfNeeded(this.$project, string);
                    }
                }));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SourceDirectorySet getKotlinSourceSet(@NotNull AndroidSourceSet $this$kotlinSourceSet) {
        void $this$getExtension$iv;
        Intrinsics.checkNotNullParameter((Object)$this$kotlinSourceSet, (String)"<this>");
        AndroidSourceSet androidSourceSet = $this$kotlinSourceSet;
        String name$iv = KotlinPluginKt.getKOTLIN_DSL_NAME();
        boolean $i$f$getExtension = false;
        SourceDirectorySet sourceDirectorySet = (SourceDirectorySet)((ExtensionAware)$this$getExtension$iv).getExtensions().getByName(name$iv);
        if (sourceDirectorySet == null) {
            boolean bl = false;
            String string = "Missing kotlinSourceSet for Android source set " + $this$kotlinSourceSet.getName();
            throw new IllegalStateException(string.toString());
        }
        return sourceDirectorySet;
    }

    /*
     * WARNING - void declaration
     */
    public static final void addKotlinSources(@NotNull AndroidSourceSet $this$addKotlinSources, @NotNull KotlinSourceSet kotlinSourceSet) {
        void $this$addExtension$iv;
        DslObject $this$addConvention$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$addKotlinSources, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kotlinSourceSet, (String)"kotlinSourceSet");
        AndroidSourceSet androidSourceSet = $this$addKotlinSources;
        String name$iv = KotlinPluginKt.getKOTLIN_DSL_NAME();
        boolean $i$f$addConvention = false;
        try {
            Class.forName("org.gradle.api.internal.HasConvention");
            bl = true;
        }
        catch (ClassNotFoundException _$iv) {
            bl = false;
        }
        boolean conventionsIsAvailable$iv = bl;
        if (conventionsIsAvailable$iv) {
            Map map = ((HasConvention)$this$addConvention$iv).getConvention().getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"this as HasConvention).convention.plugins");
            map.put(name$iv, kotlinSourceSet);
        }
        $this$addConvention$iv = new DslObject((Object)$this$addKotlinSources);
        name$iv = KotlinPluginKt.getKOTLIN_DSL_NAME();
        SourceDirectorySet extension$iv = kotlinSourceSet.getKotlin();
        boolean $i$f$addExtension = false;
        ((ExtensionAware)$this$addExtension$iv).getExtensions().add(SourceDirectorySet.class, name$iv, (Object)extension$iv);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void createDefaultDependsOnEdges(KotlinAndroidTarget target2, KotlinSourceSet kotlinSourceSet, AndroidSourceSet androidSourceSet) {
        String string;
        block8: {
            block7: {
                String string2 = androidSourceSet.getName();
                if (string2 == null) return;
                switch (string2.hashCode()) {
                    case 937500577: {
                        if (!string2.equals("androidTest")) {
                            return;
                        }
                        break block7;
                    }
                    case 3556498: {
                        if (string2.equals("test")) break;
                        return;
                    }
                    case 3343801: {
                        if (!string2.equals("main")) return;
                        string = "commonMain";
                        break block8;
                    }
                }
                string = "commonTest";
                break block8;
            }
            string = "commonTest";
            break block8;
            return;
        }
        String commonSourceSetName = string;
        KotlinSourceSet kotlinSourceSet2 = (KotlinSourceSet)KotlinProjectExtensionKt.getKotlinExtension(target2.getProject()).getSourceSets().findByName(commonSourceSetName);
        if (kotlinSourceSet2 == null) {
            return;
        }
        KotlinSourceSet commonSourceSet = kotlinSourceSet2;
        kotlinSourceSet.dependsOn(commonSourceSet);
    }

    private static final void syncKotlinAndAndroidSourceDirs(KotlinAndroidTarget target2, KotlinSourceSet kotlinSourceSet, AndroidSourceSet androidSourceSet) {
        block3: {
            block2: {
                String disambiguationClassifier = target2.getDisambiguationClassifier();
                if (disambiguationClassifier == null) break block2;
                String string = androidSourceSet.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"androidSourceSet.name");
                if (StringsKt.startsWith$default((String)string, (String)disambiguationClassifier, (boolean)false, (int)2, null)) break block3;
            }
            kotlinSourceSet.getKotlin().srcDir((Object)("src/" + androidSourceSet.getName() + "/kotlin"));
        }
        SourceDirectorySet sourceDirectorySet = kotlinSourceSet.getKotlin();
        Set set2 = androidSourceSet.getJava().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"androidSourceSet.java.srcDirs");
        Collection $this$toTypedArray$iv = set2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        File[] fileArray = thisCollection$iv.toArray(new File[0]);
        Intrinsics.checkNotNull((Object)fileArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        File[] fileArray2 = fileArray;
        sourceDirectorySet.srcDirs((Object[])Arrays.copyOf(fileArray2, fileArray2.length));
        KotlinMultiplatformPluginKt.whenEvaluated(target2.getProject(), (Function1)new Function1<Project, SourceDirectorySet>(kotlinSourceSet, androidSourceSet){
            final /* synthetic */ KotlinSourceSet $kotlinSourceSet;
            final /* synthetic */ AndroidSourceSet $androidSourceSet;
            {
                this.$kotlinSourceSet = $kotlinSourceSet;
                this.$androidSourceSet = $androidSourceSet;
                super(1);
            }

            public final SourceDirectorySet invoke(@NotNull Project $this$whenEvaluated) {
                Intrinsics.checkNotNullParameter((Object)$this$whenEvaluated, (String)"$this$whenEvaluated");
                SourceDirectorySet sourceDirectorySet = this.$kotlinSourceSet.getKotlin();
                Set set2 = this.$androidSourceSet.getJava().getSrcDirs();
                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"androidSourceSet.java.srcDirs");
                Collection $this$toTypedArray$iv = set2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                File[] fileArray = thisCollection$iv.toArray(new File[0]);
                Intrinsics.checkNotNull((Object)fileArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                File[] fileArray2 = fileArray;
                return sourceDirectorySet.srcDirs((Object[])Arrays.copyOf(fileArray2, fileArray2.length));
            }
        });
    }

    private static final void syncKotlinAndAndroidResources(KotlinAndroidTarget target2, KotlinSourceSet kotlinSourceSet, AndroidSourceSet androidSourceSet) {
        if (Intrinsics.areEqual((Object)kotlinSourceSet.getName(), (Object)androidSourceSet.getName())) {
            return;
        }
        Project project = target2.getProject();
        Object[] objectArray = new Object[]{kotlinSourceSet.getResources().getSrcDirs()};
        androidSourceSet.getResources().srcDirs(objectArray);
        Set set2 = androidSourceSet.getResources().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"androidSourceSet.resources.srcDirs");
        if (!((Collection)set2).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getResources();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "resources"));
            objectArray = new Object[]{androidSourceSet.getResources().getSrcDirs()};
            kotlinSourceSet.getResources().srcDirs(objectArray);
        }
        Set set3 = androidSourceSet.getAssets().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"androidSourceSet.assets.srcDirs");
        if (!((Collection)set3).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getAssets();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "assets"));
        }
        Set set4 = androidSourceSet.getRes().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set4, (String)"androidSourceSet.res.srcDirs");
        if (!((Collection)set4).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getRes();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "res"));
        }
        Set set5 = androidSourceSet.getAidl().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set5, (String)"androidSourceSet.aidl.srcDirs");
        if (!((Collection)set5).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getAidl();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "aidl"));
        }
        Set set6 = androidSourceSet.getRenderscript().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set6, (String)"androidSourceSet.renderscript.srcDirs");
        if (!((Collection)set6).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getRenderscript();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "rs"));
        }
        Set set7 = androidSourceSet.getJni().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set7, (String)"androidSourceSet.jni.srcDirs");
        if (!((Collection)set7).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getJni();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "jni"));
        }
        Set set8 = androidSourceSet.getJniLibs().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set8, (String)"androidSourceSet.jniLibs.srcDirs");
        if (!((Collection)set8).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getJniLibs();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "jniLibs"));
        }
        Set set9 = androidSourceSet.getShaders().getSrcDirs();
        Intrinsics.checkNotNullExpressionValue((Object)set9, (String)"androidSourceSet.shaders.srcDirs");
        if (!((Collection)set9).isEmpty()) {
            AndroidSourceDirectorySet androidSourceDirectorySet = androidSourceSet.getShaders();
            String string = kotlinSourceSet.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"kotlinSourceSet.name");
            androidSourceDirectorySet.srcDir((Object)KotlinSourceSetFactory.Companion.defaultSourceFolder(project, string, "shaders"));
        }
    }

    public static final /* synthetic */ void access$createDefaultDependsOnEdges(KotlinAndroidTarget target2, KotlinSourceSet kotlinSourceSet, AndroidSourceSet androidSourceSet) {
        SyncKotlinAndAndroidSourceSetsKt.createDefaultDependsOnEdges(target2, kotlinSourceSet, androidSourceSet);
    }

    public static final /* synthetic */ void access$syncKotlinAndAndroidSourceDirs(KotlinAndroidTarget target2, KotlinSourceSet kotlinSourceSet, AndroidSourceSet androidSourceSet) {
        SyncKotlinAndAndroidSourceSetsKt.syncKotlinAndAndroidSourceDirs(target2, kotlinSourceSet, androidSourceSet);
    }

    public static final /* synthetic */ void access$syncKotlinAndAndroidResources(KotlinAndroidTarget target2, KotlinSourceSet kotlinSourceSet, AndroidSourceSet androidSourceSet) {
        SyncKotlinAndAndroidSourceSetsKt.syncKotlinAndAndroidResources(target2, kotlinSourceSet, androidSourceSet);
    }
}

