/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.compilerRunner.KotlinNativeToolRunner;
import org.jetbrains.kotlin.compilerRunner.KotlinToolRunner;
import org.jetbrains.kotlin.compilerRunner.NativeToolRunnersKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeCompilationKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTargetPresetKt;
import org.jetbrains.kotlin.konan.CompilerVersion;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\r\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b \u0018\u00002\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010'\u001a\u00020(J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030*J\u001c\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00030*2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0016R?\u0010\u0007\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0018\u00010\u000b0\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0016\u0010\rR'\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00198FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000f\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u0018\u0010$\u001a\u00020\u0003*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner;", "Lorg/jetbrains/kotlin/compilerRunner/KotlinToolRunner;", "toolName", "", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Lorg/gradle/api/Project;)V", "classpath", "", "Ljava/io/File;", "kotlin.jvm.PlatformType", "", "getClasspath", "()Ljava/util/Set;", "classpath$delegate", "Lkotlin/Lazy;", "daemonEntryPoint", "getDaemonEntryPoint", "()Ljava/lang/String;", "displayName", "getDisplayName", "execEnvironmentBlacklist", "getExecEnvironmentBlacklist", "execEnvironmentBlacklist$delegate", "execSystemProperties", "", "getExecSystemProperties", "()Ljava/util/Map;", "execSystemProperties$delegate", "isolatedClassLoaderCacheKey", "Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$IsolatedClassLoaderCacheKey;", "getIsolatedClassLoaderCacheKey", "()Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$IsolatedClassLoaderCacheKey;", "mainClass", "getMainClass", "getToolName", "kotlinNativeCompilerJar", "getKotlinNativeCompilerJar", "(Lorg/gradle/api/Project;)Ljava/lang/String;", "checkClasspath", "", "getCustomJvmArgs", "", "transformArgs", "args", "IsolatedClassLoaderCacheKey", "kotlin-gradle-plugin_common"})
public abstract class KotlinNativeToolRunner
extends KotlinToolRunner {
    @NotNull
    private final String toolName;
    @NotNull
    private final Lazy execEnvironmentBlacklist$delegate;
    @NotNull
    private final Lazy execSystemProperties$delegate;
    @NotNull
    private final Lazy classpath$delegate;

    public KotlinNativeToolRunner(@NotNull String toolName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.toolName = toolName;
        this.execEnvironmentBlacklist$delegate = LazyKt.lazy((Function0)execEnvironmentBlacklist.2.INSTANCE);
        this.execSystemProperties$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends String>>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                Object[] objectArray;
                CompilerVersion it = NativeToolRunnersKt.getKonanVersion(this.$project);
                boolean bl = false;
                boolean konanHomeRequired = !KotlinNativeTargetPresetKt.isAtLeast(it, 1, 4, 0) || CollectionsKt.listOf((Object[])(objectArray = new String[]{"1.4-M1", "1.4-M2"})).contains(it.toString(false, false));
                Object[] objectArray2 = new Pair[]{konanHomeRequired ? TuplesKt.to((Object)"konan.home", (Object)NativeToolRunnersKt.getKonanHome(this.$project)) : null, TuplesKt.to((Object)"org.jetbrains.kotlin.cliMessageRenderer", (Object)MessageRenderer.GRADLE_STYLE.getName())};
                return MapsKt.toMap((Iterable)CollectionsKt.listOfNotNull((Object[])objectArray2));
            }
        }));
        this.classpath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<File>>(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinNativeToolRunner this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                super(0);
            }

            public final Set<File> invoke() {
                Object[] objectArray = new Object[]{KotlinNativeToolRunner.access$getKotlinNativeCompilerJar(this.this$0, this.$project), NativeToolRunnersKt.getKonanHome(this.$project) + "/konan/lib/trove4j.jar"};
                return this.$project.files(objectArray).getFiles();
            }
        }));
    }

    @NotNull
    protected final String getToolName() {
        return this.toolName;
    }

    @Override
    @NotNull
    public final String getDisplayName() {
        return this.toolName;
    }

    @Override
    @NotNull
    public final String getMainClass() {
        return "org.jetbrains.kotlin.cli.utilities.MainKt";
    }

    @Override
    @NotNull
    public final String getDaemonEntryPoint() {
        return "daemonMain";
    }

    @Override
    @NotNull
    public final Set<String> getExecEnvironmentBlacklist() {
        Lazy lazy = this.execEnvironmentBlacklist$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public final Map<String, String> getExecSystemProperties() {
        Lazy lazy = this.execSystemProperties$delegate;
        return (Map)lazy.getValue();
    }

    @Override
    public final Set<File> getClasspath() {
        Lazy lazy = this.classpath$delegate;
        return (Set)lazy.getValue();
    }

    private final String getKotlinNativeCompilerJar(Project $this$kotlinNativeCompilerJar) {
        return KotlinNativeCompilationKt.getNativeUseEmbeddableCompilerJar($this$kotlinNativeCompilerJar) ? NativeToolRunnersKt.getKonanHome($this$kotlinNativeCompilerJar) + "/konan/lib/kotlin-native-compiler-embeddable.jar" : NativeToolRunnersKt.getKonanHome($this$kotlinNativeCompilerJar) + "/konan/lib/kotlin-native.jar";
    }

    @Override
    public final void checkClasspath() {
        Set<File> set2 = this.getClasspath();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"classpath");
        if (!(!((Collection)set2).isEmpty())) {
            boolean bl = false;
            String string = StringsKt.trimIndent((String)("\n                Classpath of the tool is empty: " + this.toolName + "\n                Probably the 'kotlin.native.home' project property contains an incorrect path.\n                Please change it to the compiler root directory and rerun the build.\n            "));
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public final IsolatedClassLoaderCacheKey getIsolatedClassLoaderCacheKey() {
        Set<File> set2 = this.getClasspath();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"classpath");
        return new IsolatedClassLoaderCacheKey(set2);
    }

    @Override
    @NotNull
    public List<String> transformArgs(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.toolName), (Iterable)args);
    }

    @Override
    @NotNull
    public final List<String> getCustomJvmArgs() {
        return NativeToolRunnersKt.access$getJvmArgs(this.getProject());
    }

    public static final /* synthetic */ String access$getKotlinNativeCompilerJar(KotlinNativeToolRunner $this, Project $receiver) {
        return $this.getKotlinNativeCompilerJar($receiver);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinNativeToolRunner$IsolatedClassLoaderCacheKey;", "", "classpath", "", "Ljava/io/File;", "(Ljava/util/Set;)V", "getClasspath", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-gradle-plugin_common"})
    public static final class IsolatedClassLoaderCacheKey {
        @NotNull
        private final Set<File> classpath;

        public IsolatedClassLoaderCacheKey(@NotNull Set<? extends File> classpath2) {
            Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
            this.classpath = classpath2;
        }

        @NotNull
        public final Set<File> getClasspath() {
            return this.classpath;
        }

        @NotNull
        public final Set<File> component1() {
            return this.classpath;
        }

        @NotNull
        public final IsolatedClassLoaderCacheKey copy(@NotNull Set<? extends File> classpath2) {
            Intrinsics.checkNotNullParameter(classpath2, (String)"classpath");
            return new IsolatedClassLoaderCacheKey(classpath2);
        }

        public static /* synthetic */ IsolatedClassLoaderCacheKey copy$default(IsolatedClassLoaderCacheKey isolatedClassLoaderCacheKey, Set set2, int n, Object object) {
            if ((n & 1) != 0) {
                set2 = isolatedClassLoaderCacheKey.classpath;
            }
            return isolatedClassLoaderCacheKey.copy(set2);
        }

        @NotNull
        public String toString() {
            return "IsolatedClassLoaderCacheKey(classpath=" + this.classpath + ')';
        }

        public int hashCode() {
            return ((Object)this.classpath).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IsolatedClassLoaderCacheKey)) {
                return false;
            }
            IsolatedClassLoaderCacheKey isolatedClassLoaderCacheKey = (IsolatedClassLoaderCacheKey)other;
            return Intrinsics.areEqual(this.classpath, isolatedClassLoaderCacheKey.classpath);
        }
    }
}

