/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.AnyPsiChangeListener;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.infos.MethodCandidateInfo;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.containers.CollectionFactory;

public class JavaResolveCache {
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical;
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical;
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return project.getService(JavaResolveCache.class);
    }

    public JavaResolveCache(@NotNull Project project) {
        if (project == null) {
            JavaResolveCache.$$$reportNull$$$0(0);
        }
        this.myVarToConstValueMapPhysical = new AtomicReference();
        this.myVarToConstValueMapNonPhysical = new AtomicReference();
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                JavaResolveCache.this.clearCaches(isPhysical);
            }
        });
    }

    private void clearCaches(boolean isPhysical) {
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<? super T, ? extends PsiType> f) {
        boolean prohibitCaching;
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(1);
        }
        if (f == null) {
            JavaResolveCache.$$$reportNull$$$0(2);
        }
        boolean bl = prohibitCaching = MethodCandidateInfo.isOverloadCheck() && PsiPolyExpressionUtil.isPolyExpression(expr);
        if (prohibitCaching) {
            return f.fun(expr);
        }
        return CachedValuesManager.getProjectPsiDependentCache(expr, param -> (PsiType)f.fun(param));
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable2, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached2;
        boolean physical;
        AtomicReference<Map<PsiVariable, Object>> ref;
        Map map;
        if (variable2 == null) {
            JavaResolveCache.$$$reportNull$$$0(3);
        }
        if (computer == null) {
            JavaResolveCache.$$$reportNull$$$0(4);
        }
        if ((map = (ref = (physical = variable2.isPhysical()) ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical).get()) == null) {
            map = ConcurrencyUtil.cacheOrGet(ref, CollectionFactory.createConcurrentWeakMap());
        }
        if ((cached2 = map.get(variable2)) == NULL) {
            return null;
        }
        if (cached2 != null) {
            return cached2;
        }
        Object result2 = computer.execute(variable2, visitedVars);
        map.put(variable2, result2 == null ? NULL : result2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/impl/source/resolve/JavaResolveCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConstantValueWithCaching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

