/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.util;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.stream.Stream;
import org.jeasy.random.annotation.RandomizerArgument;

public class ConversionUtils {
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    private ConversionUtils() {
    }

    public static Object[] convertArguments(RandomizerArgument[] declaredArguments) {
        int numberOfArguments = declaredArguments.length;
        Object[] arguments = new Object[numberOfArguments];
        for (int i = 0; i < numberOfArguments; ++i) {
            Class<?> type = declaredArguments[i].type();
            String value = declaredArguments[i].value();
            if (type.isArray()) {
                Object[] values = Stream.of(value.split(",")).map(String::trim).toArray();
                arguments[i] = ConversionUtils.convertArray(values, type);
                continue;
            }
            arguments[i] = ConversionUtils.convertValue(value, type);
        }
        return arguments;
    }

    private static Object convertArray(Object array, Class<?> targetType) {
        Object[] values = (Object[])array;
        Object convertedValuesArray = Array.newInstance(targetType.getComponentType(), values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(convertedValuesArray, i, ConversionUtils.convertValue((String)values[i], targetType.getComponentType()));
        }
        return convertedValuesArray;
    }

    private static Object convertValue(String value, Class<?> targetType) {
        if (Boolean.class.equals(targetType) || Boolean.TYPE.equals(targetType)) {
            return Boolean.parseBoolean(value);
        }
        if (Byte.class.equals(targetType) || Byte.TYPE.equals(targetType)) {
            return Byte.parseByte(value);
        }
        if (Short.class.equals(targetType) || Short.TYPE.equals(targetType)) {
            return Short.parseShort(value);
        }
        if (Integer.class.equals(targetType) || Integer.TYPE.equals(targetType)) {
            return Integer.parseInt(value);
        }
        if (Long.class.equals(targetType) || Long.TYPE.equals(targetType)) {
            return Long.parseLong(value);
        }
        if (Float.class.equals(targetType) || Float.TYPE.equals(targetType)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (Double.class.equals(targetType) || Double.TYPE.equals(targetType)) {
            return Double.parseDouble(value);
        }
        if (BigInteger.class.equals(targetType)) {
            return new BigInteger(value);
        }
        if (BigDecimal.class.equals(targetType)) {
            return new BigDecimal(value);
        }
        if (java.util.Date.class.equals(targetType)) {
            return java.util.Date.from(ConversionUtils.parseDate(value).toInstant(ZoneOffset.UTC));
        }
        if (Date.class.equals(targetType)) {
            return Date.valueOf(value);
        }
        if (Time.class.equals(targetType)) {
            return Time.valueOf(value);
        }
        if (Timestamp.class.equals(targetType)) {
            return Timestamp.valueOf(value);
        }
        if (LocalDate.class.equals(targetType)) {
            return LocalDate.parse(value);
        }
        if (LocalTime.class.equals(targetType)) {
            return LocalTime.parse(value);
        }
        if (LocalDateTime.class.equals(targetType)) {
            return LocalDateTime.parse(value);
        }
        return value;
    }

    private static LocalDateTime parseDate(String value) {
        return LocalDateTime.parse(value, DateTimeFormatter.ofPattern(DATE_PATTERN));
    }
}

