/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class CharacterUtils {
    private CharacterUtils() {
    }

    public static List<Character> collectPrintableCharactersOf(Charset charset) {
        ArrayList<Character> chars = new ArrayList<Character>();
        for (int i = 0; i < 65535; ++i) {
            byte[] encoded;
            String decoded;
            String characterAsString;
            char character = (char)i;
            if (!CharacterUtils.isPrintable(character) || !(characterAsString = Character.toString(character)).equals(decoded = new String(encoded = characterAsString.getBytes(charset), charset))) continue;
            chars.add(Character.valueOf(character));
        }
        return chars;
    }

    public static List<Character> filterLetters(List<Character> characters) {
        return characters.stream().filter(Character::isLetter).collect(Collectors.toList());
    }

    private static boolean isPrintable(char character) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(character);
        return !Character.isISOControl(character) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }
}

