/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class ZonedDateTimeRangeRandomizer
extends AbstractRangeRandomizer<ZonedDateTime> {
    public ZonedDateTimeRangeRandomizer(ZonedDateTime min, ZonedDateTime max) {
        super(min, max);
    }

    public ZonedDateTimeRangeRandomizer(ZonedDateTime min, ZonedDateTime max, long seed) {
        super(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((ZonedDateTime)this.min).isAfter((ChronoZonedDateTime)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected ZonedDateTime getDefaultMinValue() {
        return EasyRandomParameters.DEFAULT_DATES_RANGE.getMin();
    }

    @Override
    protected ZonedDateTime getDefaultMaxValue() {
        return EasyRandomParameters.DEFAULT_DATES_RANGE.getMax();
    }

    @Override
    public ZonedDateTime getRandomValue() {
        long minSeconds = ((ZonedDateTime)this.min).toEpochSecond();
        long maxSeconds = ((ZonedDateTime)this.max).toEpochSecond();
        long seconds = (long)this.nextDouble(minSeconds, maxSeconds);
        int minNanoSeconds = ((ZonedDateTime)this.min).getNano();
        int maxNanoSeconds = ((ZonedDateTime)this.max).getNano();
        long nanoSeconds = (long)this.nextDouble(minNanoSeconds, maxNanoSeconds);
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanoSeconds), ((ZonedDateTime)this.min).getZone());
    }
}

