/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.range;

import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.randomizers.range.AbstractRangeRandomizer;

public class YearMonthRangeRandomizer
extends AbstractRangeRandomizer<YearMonth> {
    public YearMonthRangeRandomizer(YearMonth min, YearMonth max) {
        super(min, max);
    }

    public YearMonthRangeRandomizer(YearMonth min, YearMonth max, long seed) {
        super(min, max, seed);
    }

    @Override
    protected void checkValues() {
        if (((YearMonth)this.min).isAfter((YearMonth)this.max)) {
            throw new IllegalArgumentException("max must be after min");
        }
    }

    @Override
    protected YearMonth getDefaultMinValue() {
        ZonedDateTime defaultDateMin = EasyRandomParameters.DEFAULT_DATES_RANGE.getMin();
        return YearMonth.of(defaultDateMin.getYear(), defaultDateMin.getMonth());
    }

    @Override
    protected YearMonth getDefaultMaxValue() {
        ZonedDateTime defaultDateMax = EasyRandomParameters.DEFAULT_DATES_RANGE.getMax();
        return YearMonth.of(defaultDateMax.getYear(), defaultDateMax.getMonth());
    }

    @Override
    public YearMonth getRandomValue() {
        long minYear = ((YearMonth)this.min).getLong(ChronoField.YEAR);
        long maxYear = ((YearMonth)this.max).getLong(ChronoField.YEAR);
        long randomYear = (long)this.nextDouble(minYear, maxYear);
        long minMonth = ((YearMonth)this.min).getLong(ChronoField.MONTH_OF_YEAR);
        long maxMonth = ((YearMonth)this.max).getLong(ChronoField.MONTH_OF_YEAR);
        long randomMonth = (long)this.nextDouble(minMonth, maxMonth);
        return YearMonth.of(Math.toIntExact(randomYear), Math.toIntExact(randomMonth));
    }
}

