/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.api.ObjectFactory;
import org.jeasy.random.randomizers.range.IntegerRangeRandomizer;
import org.jeasy.random.util.ReflectionUtils;

class MapPopulator {
    private final EasyRandom easyRandom;
    private final ObjectFactory objectFactory;

    MapPopulator(EasyRandom easyRandom, ObjectFactory objectFactory) {
        this.easyRandom = easyRandom;
        this.objectFactory = objectFactory;
    }

    Map<?, ?> getRandomMap(Field field, RandomizationContext context) {
        EnumMap map;
        int randomSize = this.getRandomMapSize(context.getParameters());
        Class<EnumMap> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        if (ReflectionUtils.isInterface(fieldType)) {
            map = ReflectionUtils.getEmptyImplementationForMapInterface(fieldType);
        } else {
            try {
                map = (EnumMap)fieldType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                if (fieldType.isAssignableFrom(EnumMap.class)) {
                    if (ReflectionUtils.isParameterizedType(fieldGenericType)) {
                        Type type = ((ParameterizedType)fieldGenericType).getActualTypeArguments()[0];
                        map = new EnumMap((Class)type);
                    }
                    return null;
                }
                map = (Map)this.objectFactory.createInstance(fieldType, context);
            }
        }
        if (ReflectionUtils.isParameterizedType(fieldGenericType)) {
            ParameterizedType parameterizedType = (ParameterizedType)fieldGenericType;
            Type keyType = parameterizedType.getActualTypeArguments()[0];
            Type valueType = parameterizedType.getActualTypeArguments()[1];
            if (ReflectionUtils.isPopulatable(keyType) && ReflectionUtils.isPopulatable(valueType)) {
                for (int index = 0; index < randomSize; ++index) {
                    Object randomKey = this.easyRandom.doPopulateBean((Class)keyType, context);
                    Object randomValue = this.easyRandom.doPopulateBean((Class)valueType, context);
                    if (randomKey == null) continue;
                    map.put(randomKey, randomValue);
                }
            }
        }
        return map;
    }

    private int getRandomMapSize(EasyRandomParameters parameters) {
        EasyRandomParameters.Range<Integer> collectionSizeRange = parameters.getCollectionSizeRange();
        return new IntegerRangeRandomizer(collectionSizeRange.getMin(), collectionSizeRange.getMax(), parameters.getSeed()).getRandomValue();
    }
}

