/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.registry;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.FieldPredicates;
import org.jeasy.random.TypePredicates;
import org.jeasy.random.annotation.Exclude;
import org.jeasy.random.annotation.Priority;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerRegistry;
import org.jeasy.random.randomizers.misc.SkipRandomizer;

@Priority(value=0)
public class ExclusionRandomizerRegistry
implements RandomizerRegistry {
    private Set<Predicate<Field>> fieldPredicates = new HashSet<Predicate<Field>>();
    private Set<Predicate<Class<?>>> typePredicates = new HashSet();

    @Override
    public void init(EasyRandomParameters parameters) {
        this.fieldPredicates.add(FieldPredicates.isAnnotatedWith(Exclude.class));
        this.typePredicates.add(TypePredicates.isAnnotatedWith(Exclude.class));
    }

    @Override
    public Randomizer<?> getRandomizer(Field field) {
        for (Predicate<Field> fieldPredicate : this.fieldPredicates) {
            if (!fieldPredicate.test(field)) continue;
            return new SkipRandomizer();
        }
        return null;
    }

    @Override
    public Randomizer<?> getRandomizer(Class<?> clazz) {
        for (Predicate<Class<?>> typePredicate : this.typePredicates) {
            if (!typePredicate.test(clazz)) continue;
            return new SkipRandomizer();
        }
        return null;
    }

    public void addFieldPredicate(Predicate<Field> predicate) {
        this.fieldPredicates.add(predicate);
    }

    public void addTypePredicate(Predicate<Class<?>> predicate) {
        this.typePredicates.add(predicate);
    }
}

