/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.jeasy.random.ArrayPopulator;
import org.jeasy.random.CollectionPopulator;
import org.jeasy.random.EasyRandom;
import org.jeasy.random.MapPopulator;
import org.jeasy.random.ObjectCreationException;
import org.jeasy.random.RandomizationContext;
import org.jeasy.random.RandomizationContextStackItem;
import org.jeasy.random.api.ContextAwareRandomizer;
import org.jeasy.random.api.Randomizer;
import org.jeasy.random.api.RandomizerProvider;
import org.jeasy.random.randomizers.misc.SkipRandomizer;
import org.jeasy.random.util.CollectionUtils;
import org.jeasy.random.util.ReflectionUtils;

class FieldPopulator {
    private final EasyRandom easyRandom;
    private final ArrayPopulator arrayPopulator;
    private final CollectionPopulator collectionPopulator;
    private final MapPopulator mapPopulator;
    private final RandomizerProvider randomizerProvider;

    FieldPopulator(EasyRandom easyRandom, RandomizerProvider randomizerProvider, ArrayPopulator arrayPopulator, CollectionPopulator collectionPopulator, MapPopulator mapPopulator) {
        this.easyRandom = easyRandom;
        this.randomizerProvider = randomizerProvider;
        this.arrayPopulator = arrayPopulator;
        this.collectionPopulator = collectionPopulator;
        this.mapPopulator = mapPopulator;
    }

    void populateField(Object target, Field field, RandomizationContext context) throws IllegalAccessException {
        Randomizer<?> randomizer = this.getRandomizer(field, context);
        if (randomizer instanceof SkipRandomizer) {
            return;
        }
        if (randomizer instanceof ContextAwareRandomizer) {
            ((ContextAwareRandomizer)randomizer).setRandomizerContext(context);
        }
        context.pushStackItem(new RandomizationContextStackItem(target, field));
        if (!context.hasExceededRandomizationDepth()) {
            Object value;
            if (randomizer != null) {
                value = randomizer.getRandomValue();
            } else {
                try {
                    value = this.generateRandomValue(field, context);
                }
                catch (ObjectCreationException e) {
                    String exceptionMessage = String.format("Unable to create type: %s for field: %s of class: %s", field.getType().getName(), field.getName(), target.getClass().getName());
                    throw new ObjectCreationException(exceptionMessage, e);
                }
            }
            ReflectionUtils.setProperty(target, field, value);
        }
        context.popStackItem();
    }

    private Randomizer<?> getRandomizer(Field field, RandomizationContext context) {
        Randomizer<?> randomizer = this.randomizerProvider.getRandomizerByField(field, context);
        if (randomizer == null) {
            randomizer = this.randomizerProvider.getRandomizerByType(field.getType(), context);
        }
        return randomizer;
    }

    private Object generateRandomValue(Field field, RandomizationContext context) {
        Object value;
        Class<?> fieldType = field.getType();
        Type fieldGenericType = field.getGenericType();
        if (ReflectionUtils.isArrayType(fieldType)) {
            value = this.arrayPopulator.getRandomArray(fieldType, context);
        } else if (ReflectionUtils.isCollectionType(fieldType)) {
            value = this.collectionPopulator.getRandomCollection(field, context);
        } else if (ReflectionUtils.isMapType(fieldType)) {
            value = this.mapPopulator.getRandomMap(field, context);
        } else if (context.getParameters().isScanClasspathForConcreteTypes() && ReflectionUtils.isAbstract(fieldType) && !ReflectionUtils.isEnumType(fieldType)) {
            Class<?> randomConcreteSubType = CollectionUtils.randomElementOf(ReflectionUtils.filterSameParameterizedTypes(ReflectionUtils.getPublicConcreteSubTypesOf(fieldType), fieldGenericType));
            if (randomConcreteSubType == null) {
                throw new ObjectCreationException("Unable to find a matching concrete subtype of type: " + fieldType);
            }
            value = this.easyRandom.doPopulateBean(randomConcreteSubType, context);
        } else {
            value = this.easyRandom.doPopulateBean(fieldType, context);
        }
        return value;
    }
}

