/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web.servlet;

import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.web.logging.ServletLogger;
import org.jboss.weld.module.web.servlet.ConversationContextActivator;
import org.jboss.weld.module.web.util.servlet.ServletUtils;
import org.jboss.weld.servlet.spi.HttpContextActivationFilter;

public class ConversationFilter
implements Filter {
    public static final String CONVERSATION_FILTER_REGISTERED = ConversationFilter.class.getName() + ".registered";
    @Inject
    private BeanManagerImpl manager;
    private HttpContextActivationFilter contextActivationFilter;
    private ConversationContextActivator conversationContextActivator;

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        this.conversationContextActivator = new ConversationContextActivator(this.manager, false);
        filterConfig.getServletContext().setAttribute(CONVERSATION_FILTER_REGISTERED, Boolean.TRUE);
        this.contextActivationFilter = ServletUtils.getContextActivationFilter(this.manager, filterConfig.getServletContext());
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (this.contextActivationFilter.accepts(httpRequest)) {
                this.conversationContextActivator.startConversationContext(httpRequest);
            }
        } else {
            throw ServletLogger.LOG.onlyHttpServletLifecycleDefined();
        }
        chain.doFilter(request, response);
    }

    @Override
    public void destroy() {
    }
}

