/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.IOException;
import java.io.OutputStream;

public class CommitHeaderOutputStream
extends OutputStream {
    protected OutputStream delegate;
    protected boolean isHeadersCommitted;
    protected CommitCallback headers;

    public CommitHeaderOutputStream(OutputStream delegate, CommitCallback headers) {
        this.delegate = delegate;
        this.headers = headers;
    }

    public CommitHeaderOutputStream() {
    }

    public OutputStream getDelegate() {
        return this.delegate;
    }

    public void setDelegate(OutputStream delegate) {
        this.delegate = delegate;
    }

    public void setHeaders(CommitCallback headers) {
        this.headers = headers;
    }

    public synchronized void commit() {
        if (this.isHeadersCommitted) {
            return;
        }
        this.isHeadersCommitted = true;
        this.headers.commit();
    }

    @Override
    public void write(int i) throws IOException {
        this.commit();
        this.delegate.write(i);
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.commit();
        this.delegate.write(bytes);
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.commit();
        this.delegate.write(bytes, i, i1);
    }

    @Override
    public void flush() throws IOException {
        this.commit();
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.commit();
        this.delegate.close();
    }

    public static interface CommitCallback {
        public void commit();
    }
}

