/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RegisterBuiltin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResteasyProviderFactory factory) {
        ResteasyProviderFactory resteasyProviderFactory = factory;
        synchronized (resteasyProviderFactory) {
            if (factory.isBuiltinsRegistered() || !factory.isRegisterBuiltins()) {
                return;
            }
            try {
                RegisterBuiltin.registerProviders(factory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            factory.setBuiltinsRegistered(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProviders(ResteasyProviderFactory factory) throws Exception {
        Enumeration<URL> en = Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName());
        HashMap<String, URL> origins = new HashMap<String, URL>();
        while (en.hasMoreElements()) {
            URL url = en.nextElement();
            try (InputStream is = url.openStream();){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    origins.put(line, url);
                }
            }
        }
        for (Map.Entry entry : origins.entrySet()) {
            String line = (String)entry.getKey();
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(line);
                factory.registerProvider(clazz, true);
            }
            catch (NoClassDefFoundError e) {
                LogMessages.LOGGER.noClassDefFoundErrorError(line, (URL)entry.getValue(), e);
            }
            catch (ClassNotFoundException e) {
                LogMessages.LOGGER.classNotFoundException(line, (URL)entry.getValue(), e);
            }
        }
    }
}

