/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.SupplyMetaData;
import org.jboss.dependency.plugins.ScopedController;
import org.jboss.dependency.plugins.action.ControllerContextAction;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.api.dependency.Matcher;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.plugins.dependency.InstallScopeAction;
import org.jboss.kernel.plugins.dependency.QualifierKey;
import org.jboss.kernel.plugins.event.AbstractEventEmitter;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.event.KernelEvent;
import org.jboss.kernel.spi.event.KernelEventFilter;
import org.jboss.kernel.spi.event.KernelEventListener;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.kernel.spi.registry.KernelRegistryPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractKernelController
extends ScopedController
implements KernelController,
KernelRegistryPlugin {
    protected Kernel kernel;
    protected AbstractEventEmitter emitterDelegate = this.createEventEmitter();
    protected ConcurrentMap<Object, List<KernelControllerContext>> suppliers = new ConcurrentHashMap<Object, List<KernelControllerContext>>();

    protected Map<ControllerState, ControllerContextAction> createAliasActions() {
        HashMap<ControllerState, ControllerContextAction> map = new HashMap<ControllerState, ControllerContextAction>(super.createAliasActions());
        map.put(ControllerState.PRE_INSTALL, (ControllerContextAction)InstallScopeAction.INSTANCE);
        return map;
    }

    protected AbstractEventEmitter createEventEmitter() {
        return new AbstractEventEmitter();
    }

    @Override
    public KernelControllerContext install(BeanMetaData metaData) throws Throwable {
        return this.install(metaData, null);
    }

    @Override
    public KernelControllerContext install(BeanMetaData metaData, Object target) throws Throwable {
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, metaData, target);
        this.install(context);
        return context;
    }

    @Override
    public KernelRegistryEntry getEntry(Object name) {
        List list = name instanceof Matcher ? this.matchSupplies((Matcher)name) : (List)this.suppliers.get(name);
        if (list != null && !list.isEmpty()) {
            return (KernelRegistryEntry)list.get(0);
        }
        return null;
    }

    protected List<KernelControllerContext> matchSupplies(Matcher matcher) {
        List list = null;
        for (Map.Entry entry : this.suppliers.entrySet()) {
            if (!matcher.match(entry.getKey())) continue;
            if (!matcher.needExactMatch()) {
                return (List)entry.getValue();
            }
            if (list != null) {
                throw new IllegalArgumentException("Matcher " + matcher + " only takes exact match, but found second matching supplier.");
            }
            list = (List)entry.getValue();
        }
        return list;
    }

    public ControllerContext getContextInternal(Object name, ControllerState state, boolean enableOnDemand, Controller initiatingController) {
        ControllerContext context = super.getContextInternal(name, state, enableOnDemand, initiatingController);
        if (context != null) {
            return context;
        }
        if (name instanceof QualifierKey) {
            QualifierKey qm = (QualifierKey)name;
            return qm.search(this);
        }
        if (state == null || this.indexedInstalledState.equals((Object)state) || this.getStates().isAfterState(state, this.indexedInstalledState)) {
            KernelRegistry registry = this.kernel.getRegistry();
            try {
                return registry.findEntry(name);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSupplies(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set<SupplyMetaData> supplies = metaData.getSupplies();
        if (supplies != null) {
            boolean trace = this.log.isTraceEnabled();
            if (!supplies.isEmpty()) {
                this.lockWrite();
                try {
                    for (SupplyMetaData supplied : supplies) {
                        List old;
                        Object supply = supplied.getSupply();
                        List<KernelControllerContext> list = (CopyOnWriteArrayList<KernelControllerContext>)this.suppliers.get(supply);
                        if (list == null && (old = (List)this.suppliers.putIfAbsent(supply, list = new CopyOnWriteArrayList<KernelControllerContext>())) != null) {
                            list = old;
                        }
                        list.add(context);
                        if (!trace) continue;
                        this.log.trace((Object)("Suppliers of " + supply + ": " + list));
                    }
                }
                finally {
                    this.unlockWrite();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSupplies(KernelControllerContext context) {
        BeanMetaData metaData = context.getBeanMetaData();
        Set<SupplyMetaData> supplies = metaData.getSupplies();
        if (supplies != null) {
            boolean trace = this.log.isTraceEnabled();
            if (!supplies.isEmpty()) {
                this.lockWrite();
                try {
                    for (SupplyMetaData supplied : supplies) {
                        Object supply = supplied.getSupply();
                        List list = (List)this.suppliers.get(supply);
                        if (list == null) continue;
                        list.remove(context);
                        if (list.isEmpty()) {
                            this.suppliers.remove(supply);
                        }
                        if (!trace) continue;
                        this.log.trace((Object)("Suppliers of " + supply + ": " + list));
                    }
                }
                finally {
                    this.unlockWrite();
                }
            }
        }
    }

    @Override
    public Kernel getKernel() {
        Kernel.checkAccess();
        return this.kernel;
    }

    @Override
    public void setKernel(Kernel kernel) throws Throwable {
        Kernel.checkConfigure();
        this.kernel = kernel;
    }

    @Override
    public void fireKernelEvent(KernelEvent event) {
        this.emitterDelegate.fireKernelEvent(event);
    }

    @Override
    public void registerListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        this.emitterDelegate.registerListener(listener, filter, handback);
    }

    @Override
    public void unregisterListener(KernelEventListener listener, KernelEventFilter filter, Object handback) throws Throwable {
        this.emitterDelegate.unregisterListener(listener, filter, handback);
    }
}

