/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.test;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultAttribute;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.DefaultText;

public class XPathHelper {
    private final Document doc;

    public XPathHelper(String xml) {
        StringReader reader = new StringReader(xml);
        try {
            this.doc = new SAXReader().read((Reader)reader);
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("failed to parse XML", e);
        }
    }

    public String selectText(String xpath) {
        try {
            return ((Node)this.doc.selectObject(xpath)).getText();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Found result is not text, ensure that you have the right expression which evaluates to text.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String attributeValue(String xpath) {
        try {
            DefaultAttribute at = (DefaultAttribute)this.doc.selectObject(xpath);
            return at.getText();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Found result is not an attribute, ensure that you have the right expression which evaluates to attribute.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int count(String xpath) {
        try {
            Object o = this.doc.selectObject(xpath);
            if (o instanceof DefaultElement) {
                return 1;
            }
            List items = (List)o;
            return items.size();
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Found result cannot be counted, ensure that you have the right expression which evaluates to collection.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String selectText(String xpath, String xml) {
        return new XPathHelper(xml).selectText(xpath);
    }

    public static int count(String xpath, String xml) {
        return new XPathHelper(xml).count(xpath);
    }

    public static String attributeValue(String xpath, String xml) {
        return new XPathHelper(xml).attributeValue(xpath);
    }

    public static List<String> selectStrings(String xpath, String xml) {
        return new XPathHelper(xml).selectStrings(xpath);
    }

    private List<String> selectStrings(String xpath) {
        Object res = this.doc.selectObject(xpath);
        if (!(res instanceof List)) {
            throw new IllegalArgumentException("xpath expression must correspond to a list");
        }
        List defaultTextList = (List)res;
        if (defaultTextList.size() > 0 && !(defaultTextList.get(0) instanceof DefaultText)) {
            throw new IllegalArgumentException("xpath expression must correspond to a list of text nodes, i.e. end with: text()");
        }
        ArrayList<String> stringsList = new ArrayList<String>();
        for (Object textNode : defaultTextList) {
            stringsList.add(((DefaultText)textNode).getText());
        }
        return stringsList;
    }
}

