/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activejdbc.cache;

import java.util.Arrays;
import org.javalite.activejdbc.LogFilter;
import org.javalite.activejdbc.MetaModel;
import org.javalite.activejdbc.ModelDelegate;
import org.javalite.activejdbc.Registry;
import org.javalite.activejdbc.cache.CacheEvent;
import org.javalite.activejdbc.cache.CacheManager;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum QueryCache {
    INSTANCE;

    private static final Logger LOGGER;
    private final boolean enabled = Registry.instance().getConfiguration().cacheEnabled();
    private final CacheManager cacheManager = Registry.instance().getConfiguration().getCacheManager();

    public static QueryCache instance() {
        return INSTANCE;
    }

    public void addItem(String tableName, String query, Object[] params, Object cache) {
        if (this.enabled) {
            this.cacheManager.addCache(tableName, this.getKey(tableName, query, params), cache);
        }
    }

    public Object getItem(String tableName, String query, Object[] params) {
        if (this.enabled) {
            String key = this.getKey(tableName, query, params);
            Object item = this.cacheManager.getCache(tableName, key);
            if (item == null) {
                QueryCache.logAccess(query, params, "MISS");
            } else {
                QueryCache.logAccess(query, params, "HIT");
            }
            return item;
        }
        return null;
    }

    static void logAccess(String query, Object[] params, String access) {
        if (LOGGER.isInfoEnabled()) {
            StringBuilder log = new StringBuilder().append(access).append(", ").append('\"').append(query).append('\"');
            if (!Util.empty((Object[])params)) {
                log.append(", with parameters: ").append('<');
                Util.join((StringBuilder)log, (Object[])params, (String)">, <");
                log.append('>');
            }
            LogFilter.log(LOGGER, log.toString());
        }
    }

    private String getKey(String tableName, String query, Object[] params) {
        return tableName + query + (params == null ? null : Arrays.asList(params).toString());
    }

    public void purgeTableCache(MetaModel metaModel) {
        if (this.enabled && metaModel.cached()) {
            this.cacheManager.flush(new CacheEvent(metaModel.getTableName(), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public void purgeTableCache(String tableName) {
        MetaModel mm = ModelDelegate.metaModelFor(tableName);
        if (mm != null && this.enabled && mm.cached()) {
            this.cacheManager.flush(new CacheEvent(mm.getTableName(), ((Object)((Object)this)).getClass().getName()));
        }
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    static {
        LOGGER = LoggerFactory.getLogger(QueryCache.class);
    }
}

