/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.instrumentation;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.javalite.activejdbc.StaticMetadataGenerator;
import org.javalite.instrumentation.DBParameters;
import org.javalite.instrumentation.Instrumentation;
import org.javalite.instrumentation.Log;
import org.javalite.instrumentation.Logger;

public class ActiveJdbcInstrumentationPlugin
extends AbstractMojo {
    private String outputDirectory;
    private List<DBParameters> databases;
    private String[] outputDirectories;
    protected MavenProject project;
    private String basedir;
    private boolean generateStaticMetadata = false;

    @Override
    public void execute() throws MojoExecutionException {
        Logger.setLog(new Log(){

            @Override
            public void info(String s) {
                ActiveJdbcInstrumentationPlugin.this.getLog().info(s);
            }

            @Override
            public void error(String s) {
                ActiveJdbcInstrumentationPlugin.this.getLog().error(s);
            }
        });
        try {
            this.addProjectClassPathToPlugin();
            if (this.outputDirectories != null) {
                for (String directory : this.outputDirectories) {
                    this.instrument(directory);
                }
            } else if (this.outputDirectory != null) {
                this.instrument(this.outputDirectory);
                if (this.generateStaticMetadata) {
                    this.generateStaticMetadata(this.outputDirectory);
                }
            } else {
                this.instrument(this.project.getBuild().getOutputDirectory());
                if (this.generateStaticMetadata) {
                    this.generateStaticMetadata(this.project.getBuild().getOutputDirectory());
                }
                this.instrument(this.project.getBuild().getTestOutputDirectory());
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to instrument...", e);
        }
    }

    private void addProjectClassPathToPlugin() throws DependencyResolutionRequiredException, MalformedURLException {
        List runtimeClasspathElements = this.project.getRuntimeClasspathElements();
        for (Object runtimeClasspathElement : runtimeClasspathElements) {
            String element = (String)runtimeClasspathElement;
            URL url = new File(element).toURI().toURL();
            this.addUrlToPluginClasspath(url);
        }
    }

    private void addUrlToPluginClasspath(URL url) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        ClassRealm realm = pluginDescriptor.getClassRealm();
        realm.addURL(url);
    }

    private void instrument(String instrumentationDirectory) throws MalformedURLException {
        if (!new File(instrumentationDirectory).exists()) {
            Logger.info("Output directory " + instrumentationDirectory + " does not exist, skipping");
            return;
        }
        URL outDir = new File(instrumentationDirectory).toURI().toURL();
        this.addUrlToPluginClasspath(outDir);
        Instrumentation instrumentation = new Instrumentation();
        instrumentation.setOutputDirectory(instrumentationDirectory);
        instrumentation.instrument();
    }

    private void generateStaticMetadata(String outputDirectory) {
        if (!new File(outputDirectory).exists()) {
            Logger.info("Output directory " + outputDirectory + " does not exist, skipping");
            return;
        }
        StaticMetadataGenerator generator = new StaticMetadataGenerator();
        generator.setDBParameters(this.databases);
        generator.generate(outputDirectory);
    }
}

