/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.maven.AbstractJacocoMojo;
import org.jacoco.maven.ReportSupport;
import org.jacoco.maven.RuleConfiguration;
import org.jacoco.report.IReportGroupVisitor;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.check.IViolationsOutput;
import org.jacoco.report.check.Limit;
import org.jacoco.report.check.Rule;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class CheckMojo
extends AbstractJacocoMojo
implements IViolationsOutput {
    private static final String MSG_SKIPPING = "Skipping JaCoCo execution due to missing execution data file:";
    private static final String CHECK_SUCCESS = "All coverage checks have been met.";
    private static final String CHECK_FAILED = "Coverage checks have not been met. See log for details.";
    @Parameter(required=true)
    private List<RuleConfiguration> rules;
    @Parameter(property="jacoco.haltOnFailure", defaultValue="true", required=true)
    private boolean haltOnFailure;
    @Parameter(defaultValue="${project.build.directory}/jacoco.exec")
    private File dataFile;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> excludes;
    private boolean violations;

    private boolean canCheckCoverage() {
        if (!this.dataFile.exists()) {
            this.getLog().info((CharSequence)(MSG_SKIPPING + this.dataFile));
            return false;
        }
        File classesDirectory = new File(this.getProject().getBuild().getOutputDirectory());
        if (!classesDirectory.exists()) {
            this.getLog().info((CharSequence)("Skipping JaCoCo execution due to missing classes directory:" + classesDirectory));
            return false;
        }
        return true;
    }

    public void executeMojo() throws MojoExecutionException, MojoExecutionException {
        if (!this.canCheckCoverage()) {
            return;
        }
        this.executeCheck();
    }

    private void executeCheck() throws MojoExecutionException {
        this.violations = false;
        ReportSupport support = new ReportSupport(this.getLog());
        ArrayList<Rule> checkerrules = new ArrayList<Rule>();
        for (RuleConfiguration r : this.rules) {
            checkerrules.add(r.rule);
        }
        support.addRulesChecker(checkerrules, this);
        try {
            IReportVisitor visitor = support.initRootVisitor();
            support.loadExecutionData(this.dataFile);
            support.processProject((IReportGroupVisitor)visitor, this.getProject(), this.includes, this.excludes);
            visitor.visitEnd();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while checking code coverage: " + e.getMessage(), (Exception)e);
        }
        if (this.violations) {
            if (this.haltOnFailure) {
                throw new MojoExecutionException(CHECK_FAILED);
            }
            this.getLog().warn((CharSequence)CHECK_FAILED);
        } else {
            this.getLog().info((CharSequence)CHECK_SUCCESS);
        }
    }

    public void onViolation(ICoverageNode node, Rule rule, Limit limit, String message) {
        this.getLog().warn((CharSequence)message);
        this.violations = true;
    }
}

