/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.processor.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public final class Logger {
    private static final String MSG_PREFIX = "Instancio Processor: ";
    private final Messager messager;
    private final boolean verbose;

    public Logger(Messager messager, boolean verbose) {
        this.messager = messager;
        this.verbose = verbose;
    }

    public void debug(String message, Object ... args) {
        if (this.verbose) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, this.formatMessage(message, args));
        }
    }

    public void warn(String message, Object ... args) {
        String msg = this.formatMessage(message, args);
        Exception ex = Logger.unpackException(args);
        if (ex != null) {
            if (this.verbose) {
                msg = msg + String.format("%nStacktrace:%n%s", Logger.getStackTraceAsString(ex));
            } else {
                String cause = ex.getClass().getName() + ": " + ex.getMessage();
                msg = msg + String.format(". Caused by %s", cause);
            }
        }
        this.messager.printMessage(Diagnostic.Kind.WARNING, msg);
    }

    private String formatMessage(String message, Object ... args) {
        String msg = MSG_PREFIX + message;
        return String.format(msg, args);
    }

    private static Exception unpackException(Object ... args) {
        if (args.length > 0 && args[args.length - 1] instanceof Exception) {
            return (Exception)args[args.length - 1];
        }
        return null;
    }

    private static String getStackTraceAsString(Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }
}

