/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.processor;

import java.util.stream.Collectors;
import org.instancio.processor.MetamodelClass;
import org.jetbrains.annotations.Nullable;

class MetamodelSourceGenerator {
    private static final String PACKAGE_TEMPLATE = "package %s;";
    private static final String IMPORTS = String.format("import org.instancio.internal.selectors.MetamodelSelector;%nimport org.instancio.Selector;", new Object[0]);
    private static final String CLASS_BODY_TEMPLATE = "public class %s {%n%s%n}";
    private static final String FIELD_TEMPLATE = "\tpublic static final Selector %s = MetamodelSelector.of(%s, \"%s\");";
    private static final String CLASS_TEMPLATE = "%s%n%n%s%n%n%s";

    MetamodelSourceGenerator() {
    }

    String getSource(MetamodelClass modelClass) {
        return String.format(CLASS_TEMPLATE, this.packageDeclaration(modelClass.getPackageName()), IMPORTS, this.classBody(modelClass));
    }

    private String classBody(MetamodelClass modelClass) {
        String metaModelClassName = modelClass.getMetamodelSimpleName();
        return String.format(CLASS_BODY_TEMPLATE, metaModelClassName, this.getFields(modelClass));
    }

    private String getFields(MetamodelClass type) {
        return type.getFieldNames().stream().map(field -> String.format(FIELD_TEMPLATE, field, type.getName() + ".class", field)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String packageDeclaration(@Nullable String packageName) {
        return packageName == null ? "" : String.format(PACKAGE_TEMPLATE, packageName);
    }
}

