/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.processor;

import java.io.BufferedWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.instancio.InstancioMetamodel;
import org.instancio.processor.MetamodelClass;
import org.instancio.processor.MetamodelSourceGenerator;
import org.instancio.processor.util.Logger;

@Deprecated
@SupportedOptions(value={"instancio.verbose", "instancio.suffix"})
@SupportedAnnotationTypes(value={"org.instancio.InstancioMetamodel"})
public final class InstancioAnnotationProcessor
extends AbstractProcessor {
    private static final String CLASSES_ATTRIBUTE = "classes";
    private static final String TRUE = "true";
    private final MetamodelSourceGenerator sourceGenerator = new MetamodelSourceGenerator();
    private Types typeUtils;
    private Elements elementUtils;
    private Logger logger;
    private String classNameSuffix;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.logger = new Logger(processingEnv.getMessager(), TRUE.equalsIgnoreCase(processingEnv.getOptions().get("instancio.verbose")));
        this.classNameSuffix = processingEnv.getOptions().get("instancio.suffix");
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver() || roundEnv.errorRaised()) {
            return true;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(InstancioMetamodel.class);
        if (annotatedElements.isEmpty()) {
            this.logger.debug("No @InstancioMetamodel annotations to process", new Object[0]);
            return true;
        }
        this.logger.debug("Preparing to process %s @InstancioMetamodel annotation(s)", annotatedElements.size());
        for (Element element : annotatedElements) {
            TypeElement rootType = (TypeElement)element;
            this.getAnnotationValues(rootType, CLASSES_ATTRIBUTE).stream().filter(av -> av.getValue() instanceof TypeMirror).map(av -> this.typeUtils.asElement((TypeMirror)av.getValue())).filter(e -> e instanceof QualifiedNameable).forEach(e -> this.writeSourceFile(new MetamodelClass((QualifiedNameable)e, this.classNameSuffix), rootType));
        }
        return true;
    }

    private void writeSourceFile(MetamodelClass metaModelClass, Element element) {
        Filer filer = this.processingEnv.getFiler();
        String filename = metaModelClass.getMetamodelClassName();
        try (BufferedWriter writer = new BufferedWriter(filer.createSourceFile(filename, element).openWriter());){
            this.logger.debug("Generating metamodel class: %s", filename);
            writer.write(this.sourceGenerator.getSource(metaModelClass));
        }
        catch (Exception ex) {
            this.logger.warn("Error generating metamodel for '%s'", metaModelClass, ex);
        }
    }

    private List<AnnotationValue> getAnnotationValues(Element element, String attributeName) {
        TypeElement typeElement = this.elementUtils.getTypeElement(InstancioMetamodel.class.getCanonicalName());
        ArrayList<AnnotationValue> annotationValues = new ArrayList<AnnotationValue>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.typeUtils.isSameType(annotationMirror.getAnnotationType(), typeElement.asType())) continue;
            annotationMirror.getElementValues().forEach((executableElement, annotationValue) -> {
                if (attributeName.equals(executableElement.getSimpleName().toString())) {
                    annotationValues.addAll((List)annotationValue.getValue());
                }
            });
        }
        return annotationValues;
    }
}

