/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.instancio.internal.RootType;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.resolvers.NodeKindResolverFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PredefinedNodeCreator {
    private final RootType rootType;
    private final NodeKindResolverFacade nodeKindResolverFacade;

    PredefinedNodeCreator(RootType rootType, NodeKindResolverFacade nodeKindResolverFacade) {
        this.rootType = rootType;
        this.nodeKindResolverFacade = nodeKindResolverFacade;
    }

    @Nullable
    InternalNode createFromTemplate(@NotNull Type type, @Nullable Member member, @Nullable InternalNode parent) {
        if (type == OptionalInt.class) {
            return this.createOptional(OptionalInt.class, Integer.TYPE, member, parent);
        }
        if (type == OptionalLong.class) {
            return this.createOptional(OptionalLong.class, Long.TYPE, member, parent);
        }
        if (type == OptionalDouble.class) {
            return this.createOptional(OptionalDouble.class, Double.TYPE, member, parent);
        }
        return null;
    }

    private InternalNode createOptional(@NotNull Class<?> type, @NotNull Class<?> childType, @Nullable Member member, @Nullable InternalNode parent) {
        InternalNode result = InternalNode.builder(type, type, this.rootType).nodeKind(NodeKind.CONTAINER).member(member).parent(parent).build();
        result.setChildren(Collections.singletonList(InternalNode.builder(childType, childType, this.rootType).nodeKind(this.nodeKindResolverFacade.getNodeKind(childType)).parent(result).build()));
        return result;
    }
}

