/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.util.Collection;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.OneOfCollectionGeneratorSpec;
import org.instancio.generator.specs.OneOfCollectionSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;

public class OneOfCollectionGenerator<T>
extends AbstractGenerator<T>
implements OneOfCollectionGeneratorSpec<T>,
OneOfCollectionSpec<T> {
    private static final Hints ALLOW_EMPTY_HINT = Hints.builder().with(InternalGeneratorHint.builder().emptyResult(true).build()).build();
    private Collection<T> values;
    private boolean allowRandomValues;

    public OneOfCollectionGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "oneOf()";
    }

    @Override
    public OneOfCollectionGenerator<T> oneOf(Collection<T> values) {
        this.values = ApiValidator.notEmpty(values, "Collection must have at least one element", new Object[0]);
        return this;
    }

    @Override
    public OneOfCollectionGenerator<T> orRandom() {
        this.allowRandomValues = true;
        return this;
    }

    @Override
    public OneOfCollectionGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public T tryGenerateNonNull(Random random) {
        return random.oneOf(this.values);
    }

    @Override
    public Hints hints() {
        return this.getContext().random().diceRoll(this.allowRandomValues) ? ALLOW_EMPTY_HINT : super.hints();
    }
}

