/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.misc;

import java.util.function.Supplier;
import org.instancio.IntervalSupplier;
import org.instancio.Random;
import org.instancio.RandomUnaryOperator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.IntervalSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.PropertyBitSet;

public class IntervalGenerator<T>
extends AbstractGenerator<IntervalSupplier<T>>
implements IntervalSpec<T> {
    private final T startingValue;
    private RandomUnaryOperator<T> nextStartFunction;
    private RandomUnaryOperator<T> nextEndFunction;

    public IntervalGenerator(GeneratorContext context, T startingValue) {
        super(context);
        this.startingValue = ApiValidator.notNull(startingValue, "starting value must not be null");
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    public IntervalGenerator<T> nextStart(RandomUnaryOperator<T> fn) {
        this.nextStartFunction = fn;
        return this;
    }

    @Override
    public IntervalGenerator<T> nextEnd(RandomUnaryOperator<T> fn) {
        this.nextEndFunction = fn;
        return this;
    }

    @Override
    public IntervalGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected IntervalSupplier<T> tryGenerateNonNull(Random random) {
        ApiValidator.notNull(this.nextStartFunction, "'nextStart' function must not be null");
        ApiValidator.notNull(this.nextEndFunction, "'nextEnd' function must not be null");
        return new IntervalSupplierImpl(random, this.startingValue, this.nextStartFunction, this.nextEndFunction);
    }

    private static final class IntervalSupplierImpl<T>
    implements IntervalSupplier<T> {
        private static final String START = "start";
        private static final String END = "end";
        private final PropertyBitSet propertyBitSet = new PropertyBitSet();
        private final Random random;
        private final RandomUnaryOperator<T> nextStartFunction;
        private final RandomUnaryOperator<T> nextEndFunction;
        private T intervalStart;
        private T intervalEnd;

        private IntervalSupplierImpl(Random random, T startingValue, RandomUnaryOperator<T> nextStartFunction, RandomUnaryOperator<T> nextEndFunction) {
            this.random = random;
            this.nextStartFunction = nextStartFunction;
            this.nextEndFunction = nextEndFunction;
            this.intervalStart = startingValue;
            this.intervalEnd = nextEndFunction.apply(startingValue, random);
        }

        @Override
        public Supplier<T> start() {
            return () -> {
                this.updateState(START);
                return this.intervalStart;
            };
        }

        @Override
        public Supplier<T> end() {
            return () -> {
                this.updateState(END);
                return this.intervalEnd;
            };
        }

        private void updateState(String property) {
            if (this.propertyBitSet.get(property)) {
                this.propertyBitSet.clear();
                this.intervalStart = this.nextStartFunction.apply(this.intervalEnd, this.random);
                this.intervalEnd = this.nextEndFunction.apply(this.intervalStart, this.random);
            }
            this.propertyBitSet.set(property);
        }
    }
}

